/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value OPUS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpusSettings implements SdkPojo, Serializable, ToCopyableBuilder<OpusSettings.Builder, OpusSettings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(OpusSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Channels").getter(getter(OpusSettings::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(OpusSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CHANNELS_FIELD,
            SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final Integer channels;

    private final Integer sampleRate;

    private OpusSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Optional. Specify the average bitrate in bits per second. Valid values are multiples of 8000, from 32000 through
     * 192000. The default value is 96000, which we recommend for quality and bandwidth.
     * 
     * @return Optional. Specify the average bitrate in bits per second. Valid values are multiples of 8000, from 32000
     *         through 192000. The default value is 96000, which we recommend for quality and bandwidth.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the number of channels in this output audio track. Choosing Mono on gives you 1 output channel; choosing
     * Stereo gives you 2. In the API, valid values are 1 and 2.
     * 
     * @return Specify the number of channels in this output audio track. Choosing Mono on gives you 1 output channel;
     *         choosing Stereo gives you 2. In the API, valid values are 1 and 2.
     */
    public final Integer channels() {
        return channels;
    }

    /**
     * Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000. The default value is 48000.
     * 
     * @return Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000. The default value is 48000.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpusSettings)) {
            return false;
        }
        OpusSettings other = (OpusSettings) obj;
        return Objects.equals(bitrate(), other.bitrate()) && Objects.equals(channels(), other.channels())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpusSettings").add("Bitrate", bitrate()).add("Channels", channels())
                .add("SampleRate", sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpusSettings, T> g) {
        return obj -> g.apply((OpusSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpusSettings> {
        /**
         * Optional. Specify the average bitrate in bits per second. Valid values are multiples of 8000, from 32000
         * through 192000. The default value is 96000, which we recommend for quality and bandwidth.
         * 
         * @param bitrate
         *        Optional. Specify the average bitrate in bits per second. Valid values are multiples of 8000, from
         *        32000 through 192000. The default value is 96000, which we recommend for quality and bandwidth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the number of channels in this output audio track. Choosing Mono on gives you 1 output channel;
         * choosing Stereo gives you 2. In the API, valid values are 1 and 2.
         * 
         * @param channels
         *        Specify the number of channels in this output audio track. Choosing Mono on gives you 1 output
         *        channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000. The default value is 48000.
         * 
         * @param sampleRate
         *        Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000. The default value is 48000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private Integer channels;

        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(OpusSettings model) {
            bitrate(model.bitrate);
            channels(model.channels);
            sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final Integer getChannels() {
            return channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public OpusSettings build() {
            return new OpusSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
