/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Inserts segmentation markers at each segmentation_time period. rai_segstart sets the Random Access Indicator bit in
 * the adaptation field. rai_adapt sets the RAI bit and adds the current timecode in the private data bytes.
 * psi_segstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the
 * adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point
 * information to the adaptation field using a legacy proprietary format.
 */
@Generated("software.amazon.awssdk:codegen")
public enum M2tsSegmentationMarkers {
    NONE("NONE"),

    RAI_SEGSTART("RAI_SEGSTART"),

    RAI_ADAPT("RAI_ADAPT"),

    PSI_SEGSTART("PSI_SEGSTART"),

    EBP("EBP"),

    EBP_LEGACY("EBP_LEGACY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, M2tsSegmentationMarkers> VALUE_MAP = EnumUtils.uniqueIndex(M2tsSegmentationMarkers.class,
            M2tsSegmentationMarkers::toString);

    private final String value;

    private M2tsSegmentationMarkers(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return M2tsSegmentationMarkers corresponding to the value
     */
    public static M2tsSegmentationMarkers fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link M2tsSegmentationMarkers}s
     */
    public static Set<M2tsSegmentationMarkers> knownValues() {
        Set<M2tsSegmentationMarkers> knownValues = EnumSet.allOf(M2tsSegmentationMarkers.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
