/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
 * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled thumbnails
 * and full-resolution images of single frames. MediaConvert adds an entry in the .mpd manifest for each set of images
 * that you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images
 * that MediaConvert creates with this feature are compatible with this Roku specification:
 * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
 */
@Generated("software.amazon.awssdk:codegen")
public enum DashIsoImageBasedTrickPlay {
    NONE("NONE"),

    THUMBNAIL("THUMBNAIL"),

    THUMBNAIL_AND_FULLFRAME("THUMBNAIL_AND_FULLFRAME"),

    ADVANCED("ADVANCED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashIsoImageBasedTrickPlay> VALUE_MAP = EnumUtils.uniqueIndex(
            DashIsoImageBasedTrickPlay.class, DashIsoImageBasedTrickPlay::toString);

    private final String value;

    private DashIsoImageBasedTrickPlay(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DashIsoImageBasedTrickPlay corresponding to the value
     */
    public static DashIsoImageBasedTrickPlay fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DashIsoImageBasedTrickPlay}s
     */
    public static Set<DashIsoImageBasedTrickPlay> knownValues() {
        Set<DashIsoImageBasedTrickPlay> knownValues = EnumSet.allOf(DashIsoImageBasedTrickPlay.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
