/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the font that you want the service to use for your burn in captions when your input captions specify a font
 * that MediaConvert doesn't support. When you set Fallback font to best match, or leave blank, MediaConvert uses a
 * supported font that most closely matches the font that your input captions specify. When there are multiple
 * unsupported fonts in your input captions, MediaConvert matches each font with the supported font that matches best.
 * When you explicitly choose a replacement font, MediaConvert uses that font to replace all unsupported fonts from your
 * input.
 */
@Generated("software.amazon.awssdk:codegen")
public enum BurninSubtitleFallbackFont {
    BEST_MATCH("BEST_MATCH"),

    MONOSPACED_SANSSERIF("MONOSPACED_SANSSERIF"),

    MONOSPACED_SERIF("MONOSPACED_SERIF"),

    PROPORTIONAL_SANSSERIF("PROPORTIONAL_SANSSERIF"),

    PROPORTIONAL_SERIF("PROPORTIONAL_SERIF"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BurninSubtitleFallbackFont> VALUE_MAP = EnumUtils.uniqueIndex(
            BurninSubtitleFallbackFont.class, BurninSubtitleFallbackFont::toString);

    private final String value;

    private BurninSubtitleFallbackFont(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BurninSubtitleFallbackFont corresponding to the value
     */
    public static BurninSubtitleFallbackFont fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BurninSubtitleFallbackFont}s
     */
    public static Set<BurninSubtitleFallbackFont> knownValues() {
        Set<BurninSubtitleFallbackFont> knownValues = EnumSet.allOf(BurninSubtitleFallbackFont.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
