/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Volume::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(Volume::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(Volume::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Volume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<OntapVolumeConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField
            .<OntapVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("OntapConfiguration")
            .getter(getter(Volume::ontapConfiguration)).setter(setter(Builder::ontapConfiguration))
            .constructor(OntapVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(Volume::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Volume::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(Volume::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(Volume::volumeTypeAsString)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<LifecycleTransitionReason> LIFECYCLE_TRANSITION_REASON_FIELD = SdkField
            .<LifecycleTransitionReason> builder(MarshallingType.SDK_POJO).memberName("LifecycleTransitionReason")
            .getter(getter(Volume::lifecycleTransitionReason)).setter(setter(Builder::lifecycleTransitionReason))
            .constructor(LifecycleTransitionReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransitionReason").build())
            .build();

    private static final SdkField<List<AdministrativeAction>> ADMINISTRATIVE_ACTIONS_FIELD = SdkField
            .<List<AdministrativeAction>> builder(MarshallingType.LIST)
            .memberName("AdministrativeActions")
            .getter(getter(Volume::administrativeActions))
            .setter(setter(Builder::administrativeActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdministrativeAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdministrativeAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OpenZFSVolumeConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<OpenZFSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(Volume::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(OpenZFSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            FILE_SYSTEM_ID_FIELD, LIFECYCLE_FIELD, NAME_FIELD, ONTAP_CONFIGURATION_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD,
            VOLUME_ID_FIELD, VOLUME_TYPE_FIELD, LIFECYCLE_TRANSITION_REASON_FIELD, ADMINISTRATIVE_ACTIONS_FIELD,
            OPEN_ZFS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String fileSystemId;

    private final String lifecycle;

    private final String name;

    private final OntapVolumeConfiguration ontapConfiguration;

    private final String resourceARN;

    private final List<Tag> tags;

    private final String volumeId;

    private final String volumeType;

    private final LifecycleTransitionReason lifecycleTransitionReason;

    private final List<AdministrativeAction> administrativeActions;

    private final OpenZFSVolumeConfiguration openZFSConfiguration;

    private Volume(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.name = builder.name;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.volumeId = builder.volumeId;
        this.volumeType = builder.volumeType;
        this.lifecycleTransitionReason = builder.lifecycleTransitionReason;
        this.administrativeActions = builder.administrativeActions;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    /**
     * Returns the value of the CreationTime property for this object.
     * 
     * @return The value of the CreationTime property for this object.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The lifecycle status of the volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The volume is fully available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code> - The volume has been created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon FSx is creating the new volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Amazon FSx is deleting an existing volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx was unable to create the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the volume.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The volume is fully available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The volume has been created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon FSx is creating the new volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Amazon FSx is deleting an existing volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx was unable to create the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
     *         </p>
     *         </li>
     * @see VolumeLifecycle
     */
    public final VolumeLifecycle lifecycle() {
        return VolumeLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle status of the volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The volume is fully available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code> - The volume has been created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Amazon FSx is creating the new volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - Amazon FSx is deleting an existing volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx was unable to create the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link VolumeLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the volume.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The volume is fully available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code> - The volume has been created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Amazon FSx is creating the new volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - Amazon FSx is deleting an existing volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx was unable to create the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
     *         </p>
     *         </li>
     * @see VolumeLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * <p>
     * The name of the volume.
     * </p>
     * 
     * @return The name of the volume.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the OntapConfiguration property for this object.
     * 
     * @return The value of the OntapConfiguration property for this object.
     */
    public final OntapVolumeConfiguration ontapConfiguration() {
        return ontapConfiguration;
    }

    /**
     * Returns the value of the ResourceARN property for this object.
     * 
     * @return The value of the ResourceARN property for this object.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The system-generated, unique ID of the volume.
     * </p>
     * 
     * @return The system-generated, unique ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of the volume.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The type of the volume.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * The reason why the volume lifecycle status changed.
     * </p>
     * 
     * @return The reason why the volume lifecycle status changed.
     */
    public final LifecycleTransitionReason lifecycleTransitionReason() {
        return lifecycleTransitionReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdministrativeActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdministrativeActions() {
        return administrativeActions != null && !(administrativeActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of administrative actions for the volume that are in process or waiting to be processed. Administrative
     * actions describe changes to the volume that you have initiated using the <code>UpdateVolume</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdministrativeActions} method.
     * </p>
     * 
     * @return A list of administrative actions for the volume that are in process or waiting to be processed.
     *         Administrative actions describe changes to the volume that you have initiated using the
     *         <code>UpdateVolume</code> action.
     */
    public final List<AdministrativeAction> administrativeActions() {
        return administrativeActions;
    }

    /**
     * <p>
     * The configuration of an Amazon FSx for OpenZFS volume.
     * </p>
     * 
     * @return The configuration of an Amazon FSx for OpenZFS volume.
     */
    public final OpenZFSVolumeConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdministrativeActions() ? administrativeActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(ontapConfiguration(), other.ontapConfiguration())
                && Objects.equals(resourceARN(), other.resourceARN()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(lifecycleTransitionReason(), other.lifecycleTransitionReason())
                && hasAdministrativeActions() == other.hasAdministrativeActions()
                && Objects.equals(administrativeActions(), other.administrativeActions())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("CreationTime", creationTime()).add("FileSystemId", fileSystemId())
                .add("Lifecycle", lifecycleAsString()).add("Name", name()).add("OntapConfiguration", ontapConfiguration())
                .add("ResourceARN", resourceARN()).add("Tags", hasTags() ? tags() : null).add("VolumeId", volumeId())
                .add("VolumeType", volumeTypeAsString()).add("LifecycleTransitionReason", lifecycleTransitionReason())
                .add("AdministrativeActions", hasAdministrativeActions() ? administrativeActions() : null)
                .add("OpenZFSConfiguration", openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OntapConfiguration":
            return Optional.ofNullable(clazz.cast(ontapConfiguration()));
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "LifecycleTransitionReason":
            return Optional.ofNullable(clazz.cast(lifecycleTransitionReason()));
        case "AdministrativeActions":
            return Optional.ofNullable(clazz.cast(administrativeActions()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * Sets the value of the CreationTime property for this object.
         *
         * @param creationTime
         *        The new value for the CreationTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The lifecycle status of the volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The volume is fully available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code> - The volume has been created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon FSx is creating the new volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Amazon FSx is deleting an existing volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx was unable to create the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the volume.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The volume is fully available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The volume has been created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon FSx is creating the new volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Amazon FSx is deleting an existing volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx was unable to create the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
         *        </p>
         *        </li>
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle status of the volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The volume is fully available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code> - The volume has been created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Amazon FSx is creating the new volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - Amazon FSx is deleting an existing volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx was unable to create the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lifecycle
         *        The lifecycle status of the volume.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The volume is fully available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code> - The volume has been created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Amazon FSx is creating the new volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - Amazon FSx is deleting an existing volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx was unable to create the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx hasn't started creating the volume.
         *        </p>
         *        </li>
         * @see VolumeLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeLifecycle
         */
        Builder lifecycle(VolumeLifecycle lifecycle);

        /**
         * <p>
         * The name of the volume.
         * </p>
         * 
         * @param name
         *        The name of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * @param ontapConfiguration
         *        The new value for the OntapConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapConfiguration(OntapVolumeConfiguration ontapConfiguration);

        /**
         * Sets the value of the OntapConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OntapVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link OntapVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OntapVolumeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ontapConfiguration(OntapVolumeConfiguration)}.
         * 
         * @param ontapConfiguration
         *        a consumer that will call methods on {@link OntapVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapConfiguration(OntapVolumeConfiguration)
         */
        default Builder ontapConfiguration(Consumer<OntapVolumeConfiguration.Builder> ontapConfiguration) {
            return ontapConfiguration(OntapVolumeConfiguration.builder().applyMutation(ontapConfiguration).build());
        }

        /**
         * Sets the value of the ResourceARN property for this object.
         *
         * @param resourceARN
         *        The new value for the ResourceARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The system-generated, unique ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The system-generated, unique ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The type of the volume.
         * </p>
         * 
         * @param volumeType
         *        The type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The type of the volume.
         * </p>
         * 
         * @param volumeType
         *        The type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The reason why the volume lifecycle status changed.
         * </p>
         * 
         * @param lifecycleTransitionReason
         *        The reason why the volume lifecycle status changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason);

        /**
         * <p>
         * The reason why the volume lifecycle status changed.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleTransitionReason.Builder}
         * avoiding the need to create one manually via {@link LifecycleTransitionReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleTransitionReason.Builder#build()} is called immediately
         * and its result is passed to {@link #lifecycleTransitionReason(LifecycleTransitionReason)}.
         * 
         * @param lifecycleTransitionReason
         *        a consumer that will call methods on {@link LifecycleTransitionReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleTransitionReason(LifecycleTransitionReason)
         */
        default Builder lifecycleTransitionReason(Consumer<LifecycleTransitionReason.Builder> lifecycleTransitionReason) {
            return lifecycleTransitionReason(LifecycleTransitionReason.builder().applyMutation(lifecycleTransitionReason).build());
        }

        /**
         * <p>
         * A list of administrative actions for the volume that are in process or waiting to be processed.
         * Administrative actions describe changes to the volume that you have initiated using the
         * <code>UpdateVolume</code> action.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the volume that are in process or waiting to be processed.
         *        Administrative actions describe changes to the volume that you have initiated using the
         *        <code>UpdateVolume</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(Collection<AdministrativeAction> administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the volume that are in process or waiting to be processed.
         * Administrative actions describe changes to the volume that you have initiated using the
         * <code>UpdateVolume</code> action.
         * </p>
         * 
         * @param administrativeActions
         *        A list of administrative actions for the volume that are in process or waiting to be processed.
         *        Administrative actions describe changes to the volume that you have initiated using the
         *        <code>UpdateVolume</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeActions(AdministrativeAction... administrativeActions);

        /**
         * <p>
         * A list of administrative actions for the volume that are in process or waiting to be processed.
         * Administrative actions describe changes to the volume that you have initiated using the
         * <code>UpdateVolume</code> action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder#build()} is called immediately
         * and its result is passed to {@link #administrativeActions(List<AdministrativeAction>)}.
         * 
         * @param administrativeActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.AdministrativeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrativeActions(java.util.Collection<AdministrativeAction>)
         */
        Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions);

        /**
         * <p>
         * The configuration of an Amazon FSx for OpenZFS volume.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The configuration of an Amazon FSx for OpenZFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(OpenZFSVolumeConfiguration openZFSConfiguration);

        /**
         * <p>
         * The configuration of an Amazon FSx for OpenZFS volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenZFSVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link OpenZFSVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenZFSVolumeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #openZFSConfiguration(OpenZFSVolumeConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link OpenZFSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(OpenZFSVolumeConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<OpenZFSVolumeConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(OpenZFSVolumeConfiguration.builder().applyMutation(openZFSConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String fileSystemId;

        private String lifecycle;

        private String name;

        private OntapVolumeConfiguration ontapConfiguration;

        private String resourceARN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String volumeId;

        private String volumeType;

        private LifecycleTransitionReason lifecycleTransitionReason;

        private List<AdministrativeAction> administrativeActions = DefaultSdkAutoConstructList.getInstance();

        private OpenZFSVolumeConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            creationTime(model.creationTime);
            fileSystemId(model.fileSystemId);
            lifecycle(model.lifecycle);
            name(model.name);
            ontapConfiguration(model.ontapConfiguration);
            resourceARN(model.resourceARN);
            tags(model.tags);
            volumeId(model.volumeId);
            volumeType(model.volumeType);
            lifecycleTransitionReason(model.lifecycleTransitionReason);
            administrativeActions(model.administrativeActions);
            openZFSConfiguration(model.openZFSConfiguration);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(VolumeLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OntapVolumeConfiguration.Builder getOntapConfiguration() {
            return ontapConfiguration != null ? ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(OntapVolumeConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(OntapVolumeConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final LifecycleTransitionReason.Builder getLifecycleTransitionReason() {
            return lifecycleTransitionReason != null ? lifecycleTransitionReason.toBuilder() : null;
        }

        public final void setLifecycleTransitionReason(LifecycleTransitionReason.BuilderImpl lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason != null ? lifecycleTransitionReason.build() : null;
        }

        @Override
        public final Builder lifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
            this.lifecycleTransitionReason = lifecycleTransitionReason;
            return this;
        }

        public final List<AdministrativeAction.Builder> getAdministrativeActions() {
            List<AdministrativeAction.Builder> result = AdministrativeActionsCopier.copyToBuilder(this.administrativeActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrativeActions(Collection<AdministrativeAction.BuilderImpl> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copyFromBuilder(administrativeActions);
        }

        @Override
        public final Builder administrativeActions(Collection<AdministrativeAction> administrativeActions) {
            this.administrativeActions = AdministrativeActionsCopier.copy(administrativeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(AdministrativeAction... administrativeActions) {
            administrativeActions(Arrays.asList(administrativeActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrativeActions(Consumer<AdministrativeAction.Builder>... administrativeActions) {
            administrativeActions(Stream.of(administrativeActions)
                    .map(c -> AdministrativeAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final OpenZFSVolumeConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(OpenZFSVolumeConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(OpenZFSVolumeConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
