/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotebookExecutionResponse extends EmrResponse implements
        ToCopyableBuilder<DescribeNotebookExecutionResponse.Builder, DescribeNotebookExecutionResponse> {
    private static final SdkField<NotebookExecution> NOTEBOOK_EXECUTION_FIELD = SdkField
            .<NotebookExecution> builder(MarshallingType.SDK_POJO).memberName("NotebookExecution")
            .getter(getter(DescribeNotebookExecutionResponse::notebookExecution)).setter(setter(Builder::notebookExecution))
            .constructor(NotebookExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTION_FIELD));

    private final NotebookExecution notebookExecution;

    private DescribeNotebookExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.notebookExecution = builder.notebookExecution;
    }

    /**
     * <p>
     * Properties of the notebook execution.
     * </p>
     * 
     * @return Properties of the notebook execution.
     */
    public final NotebookExecution notebookExecution() {
        return notebookExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookExecutionResponse)) {
            return false;
        }
        DescribeNotebookExecutionResponse other = (DescribeNotebookExecutionResponse) obj;
        return Objects.equals(notebookExecution(), other.notebookExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNotebookExecutionResponse").add("NotebookExecution", notebookExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookExecution":
            return Optional.ofNullable(clazz.cast(notebookExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookExecutionResponse, T> g) {
        return obj -> g.apply((DescribeNotebookExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNotebookExecutionResponse> {
        /**
         * <p>
         * Properties of the notebook execution.
         * </p>
         * 
         * @param notebookExecution
         *        Properties of the notebook execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookExecution(NotebookExecution notebookExecution);

        /**
         * <p>
         * Properties of the notebook execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotebookExecution.Builder} avoiding the
         * need to create one manually via {@link NotebookExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotebookExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #notebookExecution(NotebookExecution)}.
         * 
         * @param notebookExecution
         *        a consumer that will call methods on {@link NotebookExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookExecution(NotebookExecution)
         */
        default Builder notebookExecution(Consumer<NotebookExecution.Builder> notebookExecution) {
            return notebookExecution(NotebookExecution.builder().applyMutation(notebookExecution).build());
        }
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private NotebookExecution notebookExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookExecutionResponse model) {
            super(model);
            notebookExecution(model.notebookExecution);
        }

        public final NotebookExecution.Builder getNotebookExecution() {
            return notebookExecution != null ? notebookExecution.toBuilder() : null;
        }

        public final void setNotebookExecution(NotebookExecution.BuilderImpl notebookExecution) {
            this.notebookExecution = notebookExecution != null ? notebookExecution.build() : null;
        }

        @Override
        public final Builder notebookExecution(NotebookExecution notebookExecution) {
            this.notebookExecution = notebookExecution;
            return this;
        }

        @Override
        public DescribeNotebookExecutionResponse build() {
            return new DescribeNotebookExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
