/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that determine when a clip begins and how long it lasts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSpan implements SdkPojo, Serializable, ToCopyableBuilder<TimeSpan.Builder, TimeSpan> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(TimeSpan::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(TimeSpan::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            DURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startTime;

    private final String duration;

    private TimeSpan(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.duration = builder.duration;
    }

    /**
     * <p>
     * The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum value:
     * 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a
     * value, Elastic Transcoder starts at the beginning of the input file.
     * </p>
     * 
     * @return The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS
     *         (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If
     *         you don't specify a value, Elastic Transcoder starts at the beginning of the input file.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths
     * of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic Transcoder creates an
     * output file from StartTime to the end of the file.
     * </p>
     * <p>
     * If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and
     * returns a warning message.
     * </p>
     * 
     * @return The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is
     *         thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic
     *         Transcoder creates an output file from StartTime to the end of the file.</p>
     *         <p>
     *         If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file
     *         and returns a warning message.
     */
    public final String duration() {
        return duration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSpan)) {
            return false;
        }
        TimeSpan other = (TimeSpan) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(duration(), other.duration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSpan").add("StartTime", startTime()).add("Duration", duration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSpan, T> g) {
        return obj -> g.apply((TimeSpan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSpan> {
        /**
         * <p>
         * The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS (maximum
         * value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't
         * specify a value, Elastic Transcoder starts at the beginning of the input file.
         * </p>
         * 
         * @param startTime
         *        The place in the input file where you want a clip to start. The format can be either HH:mm:ss.SSS
         *        (maximum value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum value: 86399.999).
         *        If you don't specify a value, Elastic Transcoder starts at the beginning of the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is
         * thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value, Elastic
         * Transcoder creates an output file from StartTime to the end of the file.
         * </p>
         * <p>
         * If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the file and
         * returns a warning message.
         * </p>
         * 
         * @param duration
         *        The duration of the clip. The format can be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is
         *        thousandths of a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a value,
         *        Elastic Transcoder creates an output file from StartTime to the end of the file.</p>
         *        <p>
         *        If you specify a value longer than the duration of the input file, Elastic Transcoder transcodes the
         *        file and returns a warning message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);
    }

    static final class BuilderImpl implements Builder {
        private String startTime;

        private String duration;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSpan model) {
            startTime(model.startTime);
            duration(model.duration);
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public TimeSpan build() {
            return new TimeSpan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
