/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to return prompts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptSearchCriteria.Builder, PromptSearchCriteria> {
    private static final SdkField<List<PromptSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<PromptSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(PromptSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PromptSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<PromptSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(PromptSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(PromptSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PromptSearchCriteria> orConditions;

    private final List<PromptSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private PromptSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an OR condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an OR condition.
     */
    public final List<PromptSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an AND condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an AND condition.
     */
    public final List<PromptSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, and
     * <code>resourceID</code>.
     * </p>
     * </note>
     * 
     * @return A leaf node condition which can be used to specify a string condition.</p> <note>
     *         <p>
     *         The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>
     *         , and <code>resourceID</code>.
     *         </p>
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptSearchCriteria)) {
            return false;
        }
        PromptSearchCriteria other = (PromptSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptSearchCriteria").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptSearchCriteria, T> g) {
        return obj -> g.apply((PromptSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptSearchCriteria> {
        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<PromptSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(PromptSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<PromptSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<PromptSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<PromptSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(PromptSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #andConditions(List<PromptSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PromptSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<PromptSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>,
         * and <code>resourceID</code>.
         * </p>
         * </note>
         * 
         * @param stringCondition
         *        A leaf node condition which can be used to specify a string condition.</p> <note>
         *        <p>
         *        The currently supported values for <code>FieldName</code> are <code>name</code>,
         *        <code>description</code>, and <code>resourceID</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>,
         * and <code>resourceID</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding
         * the need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<PromptSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<PromptSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = PromptSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = PromptSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<PromptSearchCriteria> orConditions) {
            this.orConditions = PromptSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(PromptSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> PromptSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = PromptSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = PromptSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<PromptSearchCriteria> andConditions) {
            this.andConditions = PromptSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(PromptSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> PromptSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        @Override
        public PromptSearchCriteria build() {
            return new PromptSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
