/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectEntitiesRequest extends ComprehendRequest implements
        ToCopyableBuilder<DetectEntitiesRequest.Builder, DetectEntitiesRequest> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(DetectEntitiesRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DetectEntitiesRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(DetectEntitiesRequest::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Bytes").getter(getter(DetectEntitiesRequest::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()).build();

    private static final SdkField<DocumentReaderConfig> DOCUMENT_READER_CONFIG_FIELD = SdkField
            .<DocumentReaderConfig> builder(MarshallingType.SDK_POJO).memberName("DocumentReaderConfig")
            .getter(getter(DetectEntitiesRequest::documentReaderConfig)).setter(setter(Builder::documentReaderConfig))
            .constructor(DocumentReaderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReaderConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            LANGUAGE_CODE_FIELD, ENDPOINT_ARN_FIELD, BYTES_FIELD, DOCUMENT_READER_CONFIG_FIELD));

    private final String text;

    private final String languageCode;

    private final String endpointArn;

    private final SdkBytes bytes;

    private final DocumentReaderConfig documentReaderConfig;

    private DetectEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.languageCode = builder.languageCode;
        this.endpointArn = builder.endpointArn;
        this.bytes = builder.bytes;
        this.documentReaderConfig = builder.documentReaderConfig;
    }

    /**
     * <p>
     * A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not use the
     * <code>Bytes</code> parameter.
     * </p>
     * 
     * @return A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not
     *         use the <code>Bytes</code> parameter.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * <p>
     * All input documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon
     *         Comprehend uses the language of your custom model, and it ignores any language code that you specify
     *         here.</p>
     *         <p>
     *         All input documents must be in the same language.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * <p>
     * All input documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon
     *         Comprehend uses the language of your custom model, and it ignores any language code that you specify
     *         here.</p>
     *         <p>
     *         All input documents must be in the same language.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * <p>
     * For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * 
     * @return The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model.
     *         Provide an endpoint if you want to detect entities by using your own custom model instead of the default
     *         model that is used by Amazon Comprehend.</p>
     *         <p>
     *         If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
     *         language code that you provide in your request.
     *         </p>
     *         <p>
     *         For information about endpoints, see <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * This field applies only when you use a custom entity recognition model that was trained with PDF annotations. For
     * other cases, enter your text input in the <code>Text</code> field.
     * </p>
     * <p>
     * Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file. Using a plain-text file in the
     * <code>Bytes</code> parameter is equivelent to using the <code>Text</code> parameter (the <code>Entities</code>
     * field in the response is identical).
     * </p>
     * <p>
     * You can also use the <code>Bytes</code> parameter to input an Amazon Textract <code>DetectDocumentText</code> or
     * <code>AnalyzeDocument</code> output file.
     * </p>
     * <p>
     * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services SDK to
     * detect entities, the SDK may encode the document file bytes for you.
     * </p>
     * <p>
     * The maximum length of this field depends on the input document type. For details, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time custom
     * analysis</a> in the Comprehend Developer Guide.
     * </p>
     * <p>
     * If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.
     * </p>
     * 
     * @return This field applies only when you use a custom entity recognition model that was trained with PDF
     *         annotations. For other cases, enter your text input in the <code>Text</code> field.</p>
     *         <p>
     *         Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file. Using a plain-text file in
     *         the <code>Bytes</code> parameter is equivelent to using the <code>Text</code> parameter (the
     *         <code>Entities</code> field in the response is identical).
     *         </p>
     *         <p>
     *         You can also use the <code>Bytes</code> parameter to input an Amazon Textract
     *         <code>DetectDocumentText</code> or <code>AnalyzeDocument</code> output file.
     *         </p>
     *         <p>
     *         Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web
     *         Services SDK to detect entities, the SDK may encode the document file bytes for you.
     *         </p>
     *         <p>
     *         The maximum length of this field depends on the input document type. For details, see <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time custom
     *         analysis</a> in the Comprehend Developer Guide.
     *         </p>
     *         <p>
     *         If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.
     */
    public final SdkBytes bytes() {
        return bytes;
    }

    /**
     * <p>
     * Provides configuration parameters to override the default actions for extracting text from PDF documents and
     * image files.
     * </p>
     * 
     * @return Provides configuration parameters to override the default actions for extracting text from PDF documents
     *         and image files.
     */
    public final DocumentReaderConfig documentReaderConfig() {
        return documentReaderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        hashCode = 31 * hashCode + Objects.hashCode(documentReaderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesRequest)) {
            return false;
        }
        DetectEntitiesRequest other = (DetectEntitiesRequest) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(bytes(), other.bytes())
                && Objects.equals(documentReaderConfig(), other.documentReaderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectEntitiesRequest").add("Text", text() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LanguageCode", languageCodeAsString()).add("EndpointArn", endpointArn()).add("Bytes", bytes())
                .add("DocumentReaderConfig", documentReaderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "Bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        case "DocumentReaderConfig":
            return Optional.ofNullable(clazz.cast(documentReaderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesRequest, T> g) {
        return obj -> g.apply((DetectEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectEntitiesRequest> {
        /**
         * <p>
         * A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not use
         * the <code>Bytes</code> parameter.
         * </p>
         * 
         * @param text
         *        A UTF-8 text string. The maximum string size is 100 KB. If you enter text using this parameter, do not
         *        use the <code>Bytes</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend
         * uses the language of your custom model, and it ignores any language code that you specify here.
         * </p>
         * <p>
         * All input documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon
         *        Comprehend uses the language of your custom model, and it ignores any language code that you specify
         *        here.</p>
         *        <p>
         *        All input documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend
         * uses the language of your custom model, and it ignores any language code that you specify here.
         * </p>
         * <p>
         * All input documents must be in the same language.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. If your request includes the endpoint for a custom entity recognition model, Amazon
         *        Comprehend uses the language of your custom model, and it ignores any language code that you specify
         *        here.</p>
         *        <p>
         *        All input documents must be in the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
         * endpoint if you want to detect entities by using your own custom model instead of the default model that is
         * used by Amazon Comprehend.
         * </p>
         * <p>
         * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
         * language code that you provide in your request.
         * </p>
         * <p>
         * For information about endpoints, see <a
         * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model.
         *        Provide an endpoint if you want to detect entities by using your own custom model instead of the
         *        default model that is used by Amazon Comprehend.</p>
         *        <p>
         *        If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores
         *        any language code that you provide in your request.
         *        </p>
         *        <p>
         *        For information about endpoints, see <a
         *        href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * This field applies only when you use a custom entity recognition model that was trained with PDF annotations.
         * For other cases, enter your text input in the <code>Text</code> field.
         * </p>
         * <p>
         * Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file. Using a plain-text file in the
         * <code>Bytes</code> parameter is equivelent to using the <code>Text</code> parameter (the
         * <code>Entities</code> field in the response is identical).
         * </p>
         * <p>
         * You can also use the <code>Bytes</code> parameter to input an Amazon Textract <code>DetectDocumentText</code>
         * or <code>AnalyzeDocument</code> output file.
         * </p>
         * <p>
         * Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web Services
         * SDK to detect entities, the SDK may encode the document file bytes for you.
         * </p>
         * <p>
         * The maximum length of this field depends on the input document type. For details, see <a
         * href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time custom
         * analysis</a> in the Comprehend Developer Guide.
         * </p>
         * <p>
         * If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.
         * </p>
         * 
         * @param bytes
         *        This field applies only when you use a custom entity recognition model that was trained with PDF
         *        annotations. For other cases, enter your text input in the <code>Text</code> field.</p>
         *        <p>
         *        Use the <code>Bytes</code> parameter to input a text, PDF, Word or image file. Using a plain-text file
         *        in the <code>Bytes</code> parameter is equivelent to using the <code>Text</code> parameter (the
         *        <code>Entities</code> field in the response is identical).
         *        </p>
         *        <p>
         *        You can also use the <code>Bytes</code> parameter to input an Amazon Textract
         *        <code>DetectDocumentText</code> or <code>AnalyzeDocument</code> output file.
         *        </p>
         *        <p>
         *        Provide the input document as a sequence of base64-encoded bytes. If your code uses an Amazon Web
         *        Services SDK to detect entities, the SDK may encode the document file bytes for you.
         *        </p>
         *        <p>
         *        The maximum length of this field depends on the input document type. For details, see <a
         *        href="https://docs.aws.amazon.com/comprehend/latest/dg/idp-inputs-sync.html"> Inputs for real-time
         *        custom analysis</a> in the Comprehend Developer Guide.
         *        </p>
         *        <p>
         *        If you use the <code>Bytes</code> parameter, do not use the <code>Text</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(SdkBytes bytes);

        /**
         * <p>
         * Provides configuration parameters to override the default actions for extracting text from PDF documents and
         * image files.
         * </p>
         * 
         * @param documentReaderConfig
         *        Provides configuration parameters to override the default actions for extracting text from PDF
         *        documents and image files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig);

        /**
         * <p>
         * Provides configuration parameters to override the default actions for extracting text from PDF documents and
         * image files.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentReaderConfig.Builder} avoiding
         * the need to create one manually via {@link DocumentReaderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentReaderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #documentReaderConfig(DocumentReaderConfig)}.
         * 
         * @param documentReaderConfig
         *        a consumer that will call methods on {@link DocumentReaderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentReaderConfig(DocumentReaderConfig)
         */
        default Builder documentReaderConfig(Consumer<DocumentReaderConfig.Builder> documentReaderConfig) {
            return documentReaderConfig(DocumentReaderConfig.builder().applyMutation(documentReaderConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String text;

        private String languageCode;

        private String endpointArn;

        private SdkBytes bytes;

        private DocumentReaderConfig documentReaderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesRequest model) {
            super(model);
            text(model.text);
            languageCode(model.languageCode);
            endpointArn(model.endpointArn);
            bytes(model.bytes);
            documentReaderConfig(model.documentReaderConfig);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final ByteBuffer getBytes() {
            return bytes == null ? null : bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            bytes(bytes == null ? null : SdkBytes.fromByteBuffer(bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final DocumentReaderConfig.Builder getDocumentReaderConfig() {
            return documentReaderConfig != null ? documentReaderConfig.toBuilder() : null;
        }

        public final void setDocumentReaderConfig(DocumentReaderConfig.BuilderImpl documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig != null ? documentReaderConfig.build() : null;
        }

        @Override
        public final Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectEntitiesRequest build() {
            return new DetectEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
