/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input information used for an action execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionInput.Builder, ActionExecutionInput> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .memberName("actionTypeId").getter(getter(ActionExecutionInput::actionTypeId)).setter(setter(Builder::actionTypeId))
            .constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()).build();

    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("configuration")
            .getter(getter(ActionExecutionInput::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESOLVED_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resolvedConfiguration")
            .getter(getter(ActionExecutionInput::resolvedConfiguration))
            .setter(setter(Builder::resolvedConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ActionExecutionInput::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(ActionExecutionInput::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<ArtifactDetail>> INPUT_ARTIFACTS_FIELD = SdkField
            .<List<ArtifactDetail>> builder(MarshallingType.LIST)
            .memberName("inputArtifacts")
            .getter(getter(ActionExecutionInput::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArtifactDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ActionExecutionInput::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD,
            CONFIGURATION_FIELD, RESOLVED_CONFIGURATION_FIELD, ROLE_ARN_FIELD, REGION_FIELD, INPUT_ARTIFACTS_FIELD,
            NAMESPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionTypeId actionTypeId;

    private final Map<String, String> configuration;

    private final Map<String, String> resolvedConfiguration;

    private final String roleArn;

    private final String region;

    private final List<ArtifactDetail> inputArtifacts;

    private final String namespace;

    private ActionExecutionInput(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.configuration = builder.configuration;
        this.resolvedConfiguration = builder.resolvedConfiguration;
        this.roleArn = builder.roleArn;
        this.region = builder.region;
        this.inputArtifacts = builder.inputArtifacts;
        this.namespace = builder.namespace;
    }

    /**
     * Returns the value of the ActionTypeId property for this object.
     * 
     * @return The value of the ActionTypeId property for this object.
     */
    public final ActionTypeId actionTypeId() {
        return actionTypeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration data for an action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return Configuration data for an action execution.
     */
    public final Map<String, String> configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolvedConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResolvedConfiguration() {
        return resolvedConfiguration != null && !(resolvedConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration data for an action execution with all variable references replaced with their real values for the
     * execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolvedConfiguration} method.
     * </p>
     * 
     * @return Configuration data for an action execution with all variable references replaced with their real values
     *         for the execution.
     */
    public final Map<String, String> resolvedConfiguration() {
        return resolvedConfiguration;
    }

    /**
     * <p>
     * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the
     * pipeline.
     * </p>
     * 
     * @return The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn
     *         for the pipeline.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the action, such as us-east-1.
     * </p>
     * 
     * @return The Amazon Web Services Region for the action, such as us-east-1.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of input artifacts of the action that correspond to the action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifacts} method.
     * </p>
     * 
     * @return Details of input artifacts of the action that correspond to the action execution.
     */
    public final List<ArtifactDetail> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * <p>
     * The variable namespace associated with the action. All variables produced as output by this action fall under
     * this namespace.
     * </p>
     * 
     * @return The variable namespace associated with the action. All variables produced as output by this action fall
     *         under this namespace.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResolvedConfiguration() ? resolvedConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionInput)) {
            return false;
        }
        ActionExecutionInput other = (ActionExecutionInput) obj;
        return Objects.equals(actionTypeId(), other.actionTypeId()) && hasConfiguration() == other.hasConfiguration()
                && Objects.equals(configuration(), other.configuration())
                && hasResolvedConfiguration() == other.hasResolvedConfiguration()
                && Objects.equals(resolvedConfiguration(), other.resolvedConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(region(), other.region())
                && hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(inputArtifacts(), other.inputArtifacts())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecutionInput").add("ActionTypeId", actionTypeId())
                .add("Configuration", hasConfiguration() ? configuration() : null)
                .add("ResolvedConfiguration", hasResolvedConfiguration() ? resolvedConfiguration() : null)
                .add("RoleArn", roleArn()).add("Region", region())
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null).add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypeId":
            return Optional.ofNullable(clazz.cast(actionTypeId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "resolvedConfiguration":
            return Optional.ofNullable(clazz.cast(resolvedConfiguration()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "inputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionInput, T> g) {
        return obj -> g.apply((ActionExecutionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionInput> {
        /**
         * Sets the value of the ActionTypeId property for this object.
         *
         * @param actionTypeId
         *        The new value for the ActionTypeId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypeId(ActionTypeId actionTypeId);

        /**
         * Sets the value of the ActionTypeId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ActionTypeId.Builder} avoiding the need
         * to create one manually via {@link ActionTypeId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypeId(ActionTypeId)}.
         * 
         * @param actionTypeId
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypeId(ActionTypeId)
         */
        default Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return actionTypeId(ActionTypeId.builder().applyMutation(actionTypeId).build());
        }

        /**
         * <p>
         * Configuration data for an action execution.
         * </p>
         * 
         * @param configuration
         *        Configuration data for an action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Map<String, String> configuration);

        /**
         * <p>
         * Configuration data for an action execution with all variable references replaced with their real values for
         * the execution.
         * </p>
         * 
         * @param resolvedConfiguration
         *        Configuration data for an action execution with all variable references replaced with their real
         *        values for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedConfiguration(Map<String, String> resolvedConfiguration);

        /**
         * <p>
         * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for
         * the pipeline.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn
         *        for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Web Services Region for the action, such as us-east-1.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region for the action, such as us-east-1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param inputArtifacts
         *        Details of input artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Collection<ArtifactDetail> inputArtifacts);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param inputArtifacts
         *        Details of input artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(ArtifactDetail... inputArtifacts);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #inputArtifacts(List<ArtifactDetail>)}.
         * 
         * @param inputArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ArtifactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifacts(java.util.Collection<ArtifactDetail>)
         */
        Builder inputArtifacts(Consumer<ArtifactDetail.Builder>... inputArtifacts);

        /**
         * <p>
         * The variable namespace associated with the action. All variables produced as output by this action fall under
         * this namespace.
         * </p>
         * 
         * @param namespace
         *        The variable namespace associated with the action. All variables produced as output by this action
         *        fall under this namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private ActionTypeId actionTypeId;

        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> resolvedConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private String region;

        private List<ArtifactDetail> inputArtifacts = DefaultSdkAutoConstructList.getInstance();

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionInput model) {
            actionTypeId(model.actionTypeId);
            configuration(model.configuration);
            resolvedConfiguration(model.resolvedConfiguration);
            roleArn(model.roleArn);
            region(model.region);
            inputArtifacts(model.inputArtifacts);
            namespace(model.namespace);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return actionTypeId != null ? actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final Map<String, String> getResolvedConfiguration() {
            if (resolvedConfiguration instanceof SdkAutoConstructMap) {
                return null;
            }
            return resolvedConfiguration;
        }

        public final void setResolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
        }

        @Override
        public final Builder resolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<ArtifactDetail.Builder> getInputArtifacts() {
            List<ArtifactDetail.Builder> result = ArtifactDetailListCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Collection<ArtifactDetail.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(ArtifactDetail... inputArtifacts) {
            inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<ArtifactDetail.Builder>... inputArtifacts) {
            inputArtifacts(Stream.of(inputArtifacts).map(c -> ArtifactDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public ActionExecutionInput build() {
            return new ActionExecutionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
