/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.BudgetNotificationsForAccount;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse;

public class DescribeBudgetNotificationsForAccountPublisher
implements SdkPublisher<DescribeBudgetNotificationsForAccountResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeBudgetNotificationsForAccountRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBudgetNotificationsForAccountPublisher(BudgetsAsyncClient client, DescribeBudgetNotificationsForAccountRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBudgetNotificationsForAccountPublisher(BudgetsAsyncClient client, DescribeBudgetNotificationsForAccountRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBudgetNotificationsForAccountResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBudgetNotificationsForAccountResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BudgetNotificationsForAccount> budgetNotificationsForAccount() {
        Function<DescribeBudgetNotificationsForAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgetNotificationsForAccount() != null) {
                return response.budgetNotificationsForAccount().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeBudgetNotificationsForAccountResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeBudgetNotificationsForAccountResponseFetcher
    implements AsyncPageFetcher<DescribeBudgetNotificationsForAccountResponse> {
        private DescribeBudgetNotificationsForAccountResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetNotificationsForAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeBudgetNotificationsForAccountResponse> nextPage(DescribeBudgetNotificationsForAccountResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetNotificationsForAccountPublisher.this.client.describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountPublisher.this.firstRequest);
            }
            return DescribeBudgetNotificationsForAccountPublisher.this.client.describeBudgetNotificationsForAccount((DescribeBudgetNotificationsForAccountRequest)((Object)DescribeBudgetNotificationsForAccountPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

