/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.budgets.model.AutoAdjustType;
import software.amazon.awssdk.services.budgets.model.HistoricalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoAdjustData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoAdjustData> {
    private static final SdkField<String> AUTO_ADJUST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoAdjustType").getter(AutoAdjustData.getter(AutoAdjustData::autoAdjustTypeAsString)).setter(AutoAdjustData.setter(Builder::autoAdjustType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAdjustType").build()}).build();
    private static final SdkField<HistoricalOptions> HISTORICAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HistoricalOptions").getter(AutoAdjustData.getter(AutoAdjustData::historicalOptions)).setter(AutoAdjustData.setter(Builder::historicalOptions)).constructor(HistoricalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalOptions").build()}).build();
    private static final SdkField<Instant> LAST_AUTO_ADJUST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAutoAdjustTime").getter(AutoAdjustData.getter(AutoAdjustData::lastAutoAdjustTime)).setter(AutoAdjustData.setter(Builder::lastAutoAdjustTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAutoAdjustTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ADJUST_TYPE_FIELD, HISTORICAL_OPTIONS_FIELD, LAST_AUTO_ADJUST_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoAdjustType;
    private final HistoricalOptions historicalOptions;
    private final Instant lastAutoAdjustTime;

    private AutoAdjustData(BuilderImpl builder) {
        this.autoAdjustType = builder.autoAdjustType;
        this.historicalOptions = builder.historicalOptions;
        this.lastAutoAdjustTime = builder.lastAutoAdjustTime;
    }

    public final AutoAdjustType autoAdjustType() {
        return AutoAdjustType.fromValue(this.autoAdjustType);
    }

    public final String autoAdjustTypeAsString() {
        return this.autoAdjustType;
    }

    public final HistoricalOptions historicalOptions() {
        return this.historicalOptions;
    }

    public final Instant lastAutoAdjustTime() {
        return this.lastAutoAdjustTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAdjustTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAutoAdjustTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoAdjustData)) {
            return false;
        }
        AutoAdjustData other = (AutoAdjustData)obj;
        return Objects.equals(this.autoAdjustTypeAsString(), other.autoAdjustTypeAsString()) && Objects.equals(this.historicalOptions(), other.historicalOptions()) && Objects.equals(this.lastAutoAdjustTime(), other.lastAutoAdjustTime());
    }

    public final String toString() {
        return ToString.builder((String)"AutoAdjustData").add("AutoAdjustType", (Object)this.autoAdjustTypeAsString()).add("HistoricalOptions", (Object)this.historicalOptions()).add("LastAutoAdjustTime", (Object)this.lastAutoAdjustTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoAdjustType": {
                return Optional.ofNullable(clazz.cast(this.autoAdjustTypeAsString()));
            }
            case "HistoricalOptions": {
                return Optional.ofNullable(clazz.cast(this.historicalOptions()));
            }
            case "LastAutoAdjustTime": {
                return Optional.ofNullable(clazz.cast(this.lastAutoAdjustTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoAdjustData, T> g) {
        return obj -> g.apply((AutoAdjustData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoAdjustType;
        private HistoricalOptions historicalOptions;
        private Instant lastAutoAdjustTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoAdjustData model) {
            this.autoAdjustType(model.autoAdjustType);
            this.historicalOptions(model.historicalOptions);
            this.lastAutoAdjustTime(model.lastAutoAdjustTime);
        }

        public final String getAutoAdjustType() {
            return this.autoAdjustType;
        }

        public final void setAutoAdjustType(String autoAdjustType) {
            this.autoAdjustType = autoAdjustType;
        }

        @Override
        public final Builder autoAdjustType(String autoAdjustType) {
            this.autoAdjustType = autoAdjustType;
            return this;
        }

        @Override
        public final Builder autoAdjustType(AutoAdjustType autoAdjustType) {
            this.autoAdjustType(autoAdjustType == null ? null : autoAdjustType.toString());
            return this;
        }

        public final HistoricalOptions.Builder getHistoricalOptions() {
            return this.historicalOptions != null ? this.historicalOptions.toBuilder() : null;
        }

        public final void setHistoricalOptions(HistoricalOptions.BuilderImpl historicalOptions) {
            this.historicalOptions = historicalOptions != null ? historicalOptions.build() : null;
        }

        @Override
        public final Builder historicalOptions(HistoricalOptions historicalOptions) {
            this.historicalOptions = historicalOptions;
            return this;
        }

        public final Instant getLastAutoAdjustTime() {
            return this.lastAutoAdjustTime;
        }

        public final void setLastAutoAdjustTime(Instant lastAutoAdjustTime) {
            this.lastAutoAdjustTime = lastAutoAdjustTime;
        }

        @Override
        public final Builder lastAutoAdjustTime(Instant lastAutoAdjustTime) {
            this.lastAutoAdjustTime = lastAutoAdjustTime;
            return this;
        }

        public AutoAdjustData build() {
            return new AutoAdjustData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoAdjustData> {
        public Builder autoAdjustType(String var1);

        public Builder autoAdjustType(AutoAdjustType var1);

        public Builder historicalOptions(HistoricalOptions var1);

        default public Builder historicalOptions(Consumer<HistoricalOptions.Builder> historicalOptions) {
            return this.historicalOptions((HistoricalOptions)((HistoricalOptions.Builder)HistoricalOptions.builder().applyMutation(historicalOptions)).build());
        }

        public Builder lastAutoAdjustTime(Instant var1);
    }
}

