/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClientBuilder;
import software.amazon.awssdk.services.budgets.BudgetsServiceClientConfiguration;
import software.amazon.awssdk.services.budgets.DefaultBudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.DefaultBudgetsBaseClientBuilder;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointProvider;

@SdkInternalApi
final class DefaultBudgetsAsyncClientBuilder
extends DefaultBudgetsBaseClientBuilder<BudgetsAsyncClientBuilder, BudgetsAsyncClient>
implements BudgetsAsyncClientBuilder {
    DefaultBudgetsAsyncClientBuilder() {
    }

    @Override
    public DefaultBudgetsAsyncClientBuilder endpointProvider(BudgetsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BudgetsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBudgetsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BudgetsServiceClientConfiguration serviceClientConfiguration = BudgetsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultBudgetsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

