/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.BudgetsClientBuilder;
import software.amazon.awssdk.services.budgets.BudgetsServiceClientConfiguration;
import software.amazon.awssdk.services.budgets.DefaultBudgetsBaseClientBuilder;
import software.amazon.awssdk.services.budgets.DefaultBudgetsClient;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointProvider;

@SdkInternalApi
final class DefaultBudgetsClientBuilder
extends DefaultBudgetsBaseClientBuilder<BudgetsClientBuilder, BudgetsClient>
implements BudgetsClientBuilder {
    DefaultBudgetsClientBuilder() {
    }

    @Override
    public DefaultBudgetsClientBuilder endpointProvider(BudgetsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BudgetsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBudgetsClientBuilder.validateClientOptions(clientConfiguration);
        BudgetsServiceClientConfiguration serviceClientConfiguration = BudgetsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultBudgetsClient(serviceClientConfiguration, clientConfiguration);
    }
}

