/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response of GetNotificationsForBudget
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationsForBudgetResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeNotificationsForBudgetResponse.Builder, DescribeNotificationsForBudgetResponse> {
    private static final SdkField<List<Notification>> NOTIFICATIONS_FIELD = SdkField
            .<List<Notification>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNotificationsForBudgetResponse::notifications))
            .setter(setter(Builder::notifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Notification> builder(MarshallingType.SDK_POJO)
                                            .constructor(Notification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNotificationsForBudgetResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Notification> notifications;

    private final String nextToken;

    private DescribeNotificationsForBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Notifications property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNotifications() {
        return notifications != null && !(notifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of notifications that are associated with a budget.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of notifications that are associated with a budget.
     */
    public List<Notification> notifications() {
        return notifications;
    }

    /**
     * <p>
     * The pagination token in the service response that indicates the next set of results that you can retrieve.
     * </p>
     * 
     * @return The pagination token in the service response that indicates the next set of results that you can
     *         retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationsForBudgetResponse)) {
            return false;
        }
        DescribeNotificationsForBudgetResponse other = (DescribeNotificationsForBudgetResponse) obj;
        return Objects.equals(notifications(), other.notifications()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotificationsForBudgetResponse").add("Notifications", notifications())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationsForBudgetResponse, T> g) {
        return obj -> g.apply((DescribeNotificationsForBudgetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
        /**
         * <p>
         * A list of notifications that are associated with a budget.
         * </p>
         * 
         * @param notifications
         *        A list of notifications that are associated with a budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Collection<Notification> notifications);

        /**
         * <p>
         * A list of notifications that are associated with a budget.
         * </p>
         * 
         * @param notifications
         *        A list of notifications that are associated with a budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Notification... notifications);

        /**
         * <p>
         * A list of notifications that are associated with a budget.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Notification>.Builder} avoiding the need to
         * create one manually via {@link List<Notification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Notification>.Builder#build()} is called immediately and its
         * result is passed to {@link #notifications(List<Notification>)}.
         * 
         * @param notifications
         *        a consumer that will call methods on {@link List<Notification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(List<Notification>)
         */
        Builder notifications(Consumer<Notification.Builder>... notifications);

        /**
         * <p>
         * The pagination token in the service response that indicates the next set of results that you can retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token in the service response that indicates the next set of results that you can
         *        retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private List<Notification> notifications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationsForBudgetResponse model) {
            super(model);
            notifications(model.notifications);
            nextToken(model.nextToken);
        }

        public final Collection<Notification.Builder> getNotifications() {
            return notifications != null ? notifications.stream().map(Notification::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification... notifications) {
            notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<Notification.Builder>... notifications) {
            notifications(Stream.of(notifications).map(c -> Notification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNotifications(Collection<Notification.BuilderImpl> notifications) {
            this.notifications = NotificationsCopier.copyFromBuilder(notifications);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationsForBudgetResponse build() {
            return new DescribeNotificationsForBudgetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
