/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BudgetMarshaller {
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BUDGETLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetLimit").isBinary(false).build();
    private static final MarshallingInfo<Map> COSTFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostFilters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COSTTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostTypes").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeUnit").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CALCULATEDSPEND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CalculatedSpend").isBinary(false).build();
    private static final MarshallingInfo<String> BUDGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetType").isBinary(false).build();
    private static final BudgetMarshaller INSTANCE = new BudgetMarshaller();

    private BudgetMarshaller() {
    }

    public static BudgetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Budget budget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)budget, (String)"budget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)budget.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall((Object)budget.budgetLimit(), BUDGETLIMIT_BINDING);
            protocolMarshaller.marshall(budget.costFilters(), COSTFILTERS_BINDING);
            protocolMarshaller.marshall((Object)budget.costTypes(), COSTTYPES_BINDING);
            protocolMarshaller.marshall((Object)budget.timeUnitString(), TIMEUNIT_BINDING);
            protocolMarshaller.marshall((Object)budget.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)budget.calculatedSpend(), CALCULATEDSPEND_BINDING);
            protocolMarshaller.marshall((Object)budget.budgetTypeString(), BUDGETTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

