/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.math.BigDecimal;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Spend;

@SdkInternalApi
public class SpendMarshaller {
    private static final MarshallingInfo<BigDecimal> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BIG_DECIMAL).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Amount").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final SpendMarshaller INSTANCE = new SpendMarshaller();

    public static SpendMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Spend spend, ProtocolMarshaller protocolMarshaller) {
        if (spend == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)spend.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)spend.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

