/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.BudgetType;
import software.amazon.awssdk.services.budgets.model.CalculatedSpend;
import software.amazon.awssdk.services.budgets.model.CostFiltersCopier;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.services.budgets.model.TimeUnit;
import software.amazon.awssdk.services.budgets.transform.BudgetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Budget
implements StructuredPojo,
ToCopyableBuilder<Builder, Budget> {
    private final String budgetName;
    private final Spend budgetLimit;
    private final Map<String, List<String>> costFilters;
    private final CostTypes costTypes;
    private final String timeUnit;
    private final TimePeriod timePeriod;
    private final CalculatedSpend calculatedSpend;
    private final String budgetType;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Spend budgetLimit() {
        return this.budgetLimit;
    }

    public Map<String, List<String>> costFilters() {
        return this.costFilters;
    }

    public CostTypes costTypes() {
        return this.costTypes;
    }

    public TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public String timeUnitString() {
        return this.timeUnit;
    }

    public TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public CalculatedSpend calculatedSpend() {
        return this.calculatedSpend;
    }

    public BudgetType budgetType() {
        return BudgetType.fromValue(this.budgetType);
    }

    public String budgetTypeString() {
        return this.budgetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.budgetName() == null ? 0 : this.budgetName().hashCode());
        hashCode = 31 * hashCode + (this.budgetLimit() == null ? 0 : this.budgetLimit().hashCode());
        hashCode = 31 * hashCode + (this.costFilters() == null ? 0 : this.costFilters().hashCode());
        hashCode = 31 * hashCode + (this.costTypes() == null ? 0 : this.costTypes().hashCode());
        hashCode = 31 * hashCode + (this.timeUnitString() == null ? 0 : this.timeUnitString().hashCode());
        hashCode = 31 * hashCode + (this.timePeriod() == null ? 0 : this.timePeriod().hashCode());
        hashCode = 31 * hashCode + (this.calculatedSpend() == null ? 0 : this.calculatedSpend().hashCode());
        hashCode = 31 * hashCode + (this.budgetTypeString() == null ? 0 : this.budgetTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.budgetLimit() == null ^ this.budgetLimit() == null) {
            return false;
        }
        if (other.budgetLimit() != null && !other.budgetLimit().equals(this.budgetLimit())) {
            return false;
        }
        if (other.costFilters() == null ^ this.costFilters() == null) {
            return false;
        }
        if (other.costFilters() != null && !other.costFilters().equals(this.costFilters())) {
            return false;
        }
        if (other.costTypes() == null ^ this.costTypes() == null) {
            return false;
        }
        if (other.costTypes() != null && !other.costTypes().equals(this.costTypes())) {
            return false;
        }
        if (other.timeUnitString() == null ^ this.timeUnitString() == null) {
            return false;
        }
        if (other.timeUnitString() != null && !other.timeUnitString().equals(this.timeUnitString())) {
            return false;
        }
        if (other.timePeriod() == null ^ this.timePeriod() == null) {
            return false;
        }
        if (other.timePeriod() != null && !other.timePeriod().equals(this.timePeriod())) {
            return false;
        }
        if (other.calculatedSpend() == null ^ this.calculatedSpend() == null) {
            return false;
        }
        if (other.calculatedSpend() != null && !other.calculatedSpend().equals(this.calculatedSpend())) {
            return false;
        }
        if (other.budgetTypeString() == null ^ this.budgetTypeString() == null) {
            return false;
        }
        return other.budgetTypeString() == null || other.budgetTypeString().equals(this.budgetTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.budgetLimit() != null) {
            sb.append("BudgetLimit: ").append(this.budgetLimit()).append(",");
        }
        if (this.costFilters() != null) {
            sb.append("CostFilters: ").append(this.costFilters()).append(",");
        }
        if (this.costTypes() != null) {
            sb.append("CostTypes: ").append(this.costTypes()).append(",");
        }
        if (this.timeUnitString() != null) {
            sb.append("TimeUnit: ").append(this.timeUnitString()).append(",");
        }
        if (this.timePeriod() != null) {
            sb.append("TimePeriod: ").append(this.timePeriod()).append(",");
        }
        if (this.calculatedSpend() != null) {
            sb.append("CalculatedSpend: ").append(this.calculatedSpend()).append(",");
        }
        if (this.budgetTypeString() != null) {
            sb.append("BudgetType: ").append(this.budgetTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetName": {
                return Optional.of(clazz.cast(this.budgetName()));
            }
            case "BudgetLimit": {
                return Optional.of(clazz.cast(this.budgetLimit()));
            }
            case "CostFilters": {
                return Optional.of(clazz.cast(this.costFilters()));
            }
            case "CostTypes": {
                return Optional.of(clazz.cast(this.costTypes()));
            }
            case "TimeUnit": {
                return Optional.of(clazz.cast(this.timeUnitString()));
            }
            case "TimePeriod": {
                return Optional.of(clazz.cast(this.timePeriod()));
            }
            case "CalculatedSpend": {
                return Optional.of(clazz.cast(this.calculatedSpend()));
            }
            case "BudgetType": {
                return Optional.of(clazz.cast(this.budgetTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String budgetName;
        private Spend budgetLimit;
        private Map<String, List<String>> costFilters;
        private CostTypes costTypes;
        private String timeUnit;
        private TimePeriod timePeriod;
        private CalculatedSpend calculatedSpend;
        private String budgetType;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            this.budgetName(model.budgetName);
            this.budgetLimit(model.budgetLimit);
            this.costFilters(model.costFilters);
            this.costTypes(model.costTypes);
            this.timeUnit(model.timeUnit);
            this.timePeriod(model.timePeriod);
            this.calculatedSpend(model.calculatedSpend);
            this.budgetType(model.budgetType);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Spend.Builder getBudgetLimit() {
            return this.budgetLimit != null ? this.budgetLimit.toBuilder() : null;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final void setBudgetLimit(Spend.BuilderImpl budgetLimit) {
            this.budgetLimit = budgetLimit != null ? budgetLimit.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            return this.costFilters;
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        public final CostTypes.Builder getCostTypes() {
            return this.costTypes != null ? this.costTypes.toBuilder() : null;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final CalculatedSpend.Builder getCalculatedSpend() {
            return this.calculatedSpend != null ? this.calculatedSpend.toBuilder() : null;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final void setCalculatedSpend(CalculatedSpend.BuilderImpl calculatedSpend) {
            this.calculatedSpend = calculatedSpend != null ? calculatedSpend.build() : null;
        }

        public final String getBudgetType() {
            return this.budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType.toString());
            return this;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        public Budget build() {
            return new Budget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Budget> {
        public Builder budgetName(String var1);

        public Builder budgetLimit(Spend var1);

        public Builder costFilters(Map<String, ? extends Collection<String>> var1);

        public Builder costTypes(CostTypes var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder timePeriod(TimePeriod var1);

        public Builder calculatedSpend(CalculatedSpend var1);

        public Builder budgetType(String var1);

        public Builder budgetType(BudgetType var1);
    }
}

