/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.BudgetType;
import software.amazon.awssdk.services.budgets.model.CalculatedSpend;
import software.amazon.awssdk.services.budgets.model.CostFiltersCopier;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.services.budgets.model.TimeUnit;
import software.amazon.awssdk.services.budgets.transform.BudgetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Budget
implements StructuredPojo,
ToCopyableBuilder<Builder, Budget> {
    private final String budgetName;
    private final Spend budgetLimit;
    private final Map<String, List<String>> costFilters;
    private final CostTypes costTypes;
    private final String timeUnit;
    private final TimePeriod timePeriod;
    private final CalculatedSpend calculatedSpend;
    private final String budgetType;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Spend budgetLimit() {
        return this.budgetLimit;
    }

    public Map<String, List<String>> costFilters() {
        return this.costFilters;
    }

    public CostTypes costTypes() {
        return this.costTypes;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public CalculatedSpend calculatedSpend() {
        return this.calculatedSpend;
    }

    public String budgetType() {
        return this.budgetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.budgetName() == null ? 0 : this.budgetName().hashCode());
        hashCode = 31 * hashCode + (this.budgetLimit() == null ? 0 : this.budgetLimit().hashCode());
        hashCode = 31 * hashCode + (this.costFilters() == null ? 0 : this.costFilters().hashCode());
        hashCode = 31 * hashCode + (this.costTypes() == null ? 0 : this.costTypes().hashCode());
        hashCode = 31 * hashCode + (this.timeUnit() == null ? 0 : this.timeUnit().hashCode());
        hashCode = 31 * hashCode + (this.timePeriod() == null ? 0 : this.timePeriod().hashCode());
        hashCode = 31 * hashCode + (this.calculatedSpend() == null ? 0 : this.calculatedSpend().hashCode());
        hashCode = 31 * hashCode + (this.budgetType() == null ? 0 : this.budgetType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.budgetLimit() == null ^ this.budgetLimit() == null) {
            return false;
        }
        if (other.budgetLimit() != null && !other.budgetLimit().equals(this.budgetLimit())) {
            return false;
        }
        if (other.costFilters() == null ^ this.costFilters() == null) {
            return false;
        }
        if (other.costFilters() != null && !other.costFilters().equals(this.costFilters())) {
            return false;
        }
        if (other.costTypes() == null ^ this.costTypes() == null) {
            return false;
        }
        if (other.costTypes() != null && !other.costTypes().equals(this.costTypes())) {
            return false;
        }
        if (other.timeUnit() == null ^ this.timeUnit() == null) {
            return false;
        }
        if (other.timeUnit() != null && !other.timeUnit().equals(this.timeUnit())) {
            return false;
        }
        if (other.timePeriod() == null ^ this.timePeriod() == null) {
            return false;
        }
        if (other.timePeriod() != null && !other.timePeriod().equals(this.timePeriod())) {
            return false;
        }
        if (other.calculatedSpend() == null ^ this.calculatedSpend() == null) {
            return false;
        }
        if (other.calculatedSpend() != null && !other.calculatedSpend().equals(this.calculatedSpend())) {
            return false;
        }
        if (other.budgetType() == null ^ this.budgetType() == null) {
            return false;
        }
        return other.budgetType() == null || other.budgetType().equals(this.budgetType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.budgetLimit() != null) {
            sb.append("BudgetLimit: ").append(this.budgetLimit()).append(",");
        }
        if (this.costFilters() != null) {
            sb.append("CostFilters: ").append(this.costFilters()).append(",");
        }
        if (this.costTypes() != null) {
            sb.append("CostTypes: ").append(this.costTypes()).append(",");
        }
        if (this.timeUnit() != null) {
            sb.append("TimeUnit: ").append(this.timeUnit()).append(",");
        }
        if (this.timePeriod() != null) {
            sb.append("TimePeriod: ").append(this.timePeriod()).append(",");
        }
        if (this.calculatedSpend() != null) {
            sb.append("CalculatedSpend: ").append(this.calculatedSpend()).append(",");
        }
        if (this.budgetType() != null) {
            sb.append("BudgetType: ").append(this.budgetType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String budgetName;
        private Spend budgetLimit;
        private Map<String, List<String>> costFilters;
        private CostTypes costTypes;
        private String timeUnit;
        private TimePeriod timePeriod;
        private CalculatedSpend calculatedSpend;
        private String budgetType;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            this.setBudgetName(model.budgetName);
            this.setBudgetLimit(model.budgetLimit);
            this.setCostFilters(model.costFilters);
            this.setCostTypes(model.costTypes);
            this.setTimeUnit(model.timeUnit);
            this.setTimePeriod(model.timePeriod);
            this.setCalculatedSpend(model.calculatedSpend);
            this.setBudgetType(model.budgetType);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Spend getBudgetLimit() {
            return this.budgetLimit;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final void setBudgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            return this.costFilters;
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        public final CostTypes getCostTypes() {
            return this.costTypes;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final void setCostTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final TimePeriod getTimePeriod() {
            return this.timePeriod;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
        }

        public final CalculatedSpend getCalculatedSpend() {
            return this.calculatedSpend;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final void setCalculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
        }

        public final String getBudgetType() {
            return this.budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType.toString());
            return this;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        public Budget build() {
            return new Budget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Budget> {
        public Builder budgetName(String var1);

        public Builder budgetLimit(Spend var1);

        public Builder costFilters(Map<String, ? extends Collection<String>> var1);

        public Builder costTypes(CostTypes var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder timePeriod(TimePeriod var1);

        public Builder calculatedSpend(CalculatedSpend var1);

        public Builder budgetType(String var1);

        public Builder budgetType(BudgetType var1);
    }
}

