/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.transform.CalculatedSpendMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculatedSpend
implements StructuredPojo,
ToCopyableBuilder<Builder, CalculatedSpend> {
    private final Spend actualSpend;
    private final Spend forecastedSpend;

    private CalculatedSpend(BuilderImpl builder) {
        this.actualSpend = builder.actualSpend;
        this.forecastedSpend = builder.forecastedSpend;
    }

    public Spend actualSpend() {
        return this.actualSpend;
    }

    public Spend forecastedSpend() {
        return this.forecastedSpend;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastedSpend());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculatedSpend)) {
            return false;
        }
        CalculatedSpend other = (CalculatedSpend)obj;
        return Objects.equals(this.actualSpend(), other.actualSpend()) && Objects.equals(this.forecastedSpend(), other.forecastedSpend());
    }

    public String toString() {
        return ToString.builder((String)"CalculatedSpend").add("ActualSpend", (Object)this.actualSpend()).add("ForecastedSpend", (Object)this.forecastedSpend()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActualSpend": {
                return Optional.ofNullable(clazz.cast(this.actualSpend()));
            }
            case "ForecastedSpend": {
                return Optional.ofNullable(clazz.cast(this.forecastedSpend()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CalculatedSpendMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Spend actualSpend;
        private Spend forecastedSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculatedSpend model) {
            this.actualSpend(model.actualSpend);
            this.forecastedSpend(model.forecastedSpend);
        }

        public final Spend.Builder getActualSpend() {
            return this.actualSpend != null ? this.actualSpend.toBuilder() : null;
        }

        @Override
        public final Builder actualSpend(Spend actualSpend) {
            this.actualSpend = actualSpend;
            return this;
        }

        public final void setActualSpend(Spend.BuilderImpl actualSpend) {
            this.actualSpend = actualSpend != null ? actualSpend.build() : null;
        }

        public final Spend.Builder getForecastedSpend() {
            return this.forecastedSpend != null ? this.forecastedSpend.toBuilder() : null;
        }

        @Override
        public final Builder forecastedSpend(Spend forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            return this;
        }

        public final void setForecastedSpend(Spend.BuilderImpl forecastedSpend) {
            this.forecastedSpend = forecastedSpend != null ? forecastedSpend.build() : null;
        }

        public CalculatedSpend build() {
            return new CalculatedSpend(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CalculatedSpend> {
        public Builder actualSpend(Spend var1);

        default public Builder actualSpend(Consumer<Spend.Builder> actualSpend) {
            return this.actualSpend((Spend)((Spend.Builder)Spend.builder().applyMutation(actualSpend)).build());
        }

        public Builder forecastedSpend(Spend var1);

        default public Builder forecastedSpend(Consumer<Spend.Builder> forecastedSpend) {
            return this.forecastedSpend((Spend)((Spend.Builder)Spend.builder().applyMutation(forecastedSpend)).build());
        }
    }
}

