/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSpendingLimitRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, UpdateSpendingLimitRequest> {
    private static final SdkField<String> SPENDING_LIMIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spendingLimitArn").getter(UpdateSpendingLimitRequest.getter(UpdateSpendingLimitRequest::spendingLimitArn)).setter(UpdateSpendingLimitRequest.setter(Builder::spendingLimitArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("spendingLimitArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateSpendingLimitRequest.getter(UpdateSpendingLimitRequest::clientToken)).setter(UpdateSpendingLimitRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SPENDING_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spendingLimit").getter(UpdateSpendingLimitRequest.getter(UpdateSpendingLimitRequest::spendingLimit)).setter(UpdateSpendingLimitRequest.setter(Builder::spendingLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spendingLimit").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(UpdateSpendingLimitRequest.getter(UpdateSpendingLimitRequest::timePeriod)).setter(UpdateSpendingLimitRequest.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPENDING_LIMIT_ARN_FIELD, CLIENT_TOKEN_FIELD, SPENDING_LIMIT_FIELD, TIME_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSpendingLimitRequest.memberNameToFieldInitializer();
    private final String spendingLimitArn;
    private final String clientToken;
    private final String spendingLimit;
    private final TimePeriod timePeriod;

    private UpdateSpendingLimitRequest(BuilderImpl builder) {
        super(builder);
        this.spendingLimitArn = builder.spendingLimitArn;
        this.clientToken = builder.clientToken;
        this.spendingLimit = builder.spendingLimit;
        this.timePeriod = builder.timePeriod;
    }

    public final String spendingLimitArn() {
        return this.spendingLimitArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String spendingLimit() {
        return this.spendingLimit;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spendingLimitArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spendingLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpendingLimitRequest)) {
            return false;
        }
        UpdateSpendingLimitRequest other = (UpdateSpendingLimitRequest)((Object)obj);
        return Objects.equals(this.spendingLimitArn(), other.spendingLimitArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.spendingLimit(), other.spendingLimit()) && Objects.equals(this.timePeriod(), other.timePeriod());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSpendingLimitRequest").add("SpendingLimitArn", (Object)this.spendingLimitArn()).add("ClientToken", (Object)this.clientToken()).add("SpendingLimit", (Object)this.spendingLimit()).add("TimePeriod", (Object)this.timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spendingLimitArn": {
                return Optional.ofNullable(clazz.cast(this.spendingLimitArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "spendingLimit": {
                return Optional.ofNullable(clazz.cast(this.spendingLimit()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spendingLimitArn", SPENDING_LIMIT_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("spendingLimit", SPENDING_LIMIT_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpendingLimitRequest, T> g) {
        return obj -> g.apply((UpdateSpendingLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private String spendingLimitArn;
        private String clientToken;
        private String spendingLimit;
        private TimePeriod timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpendingLimitRequest model) {
            super(model);
            this.spendingLimitArn(model.spendingLimitArn);
            this.clientToken(model.clientToken);
            this.spendingLimit(model.spendingLimit);
            this.timePeriod(model.timePeriod);
        }

        public final String getSpendingLimitArn() {
            return this.spendingLimitArn;
        }

        public final void setSpendingLimitArn(String spendingLimitArn) {
            this.spendingLimitArn = spendingLimitArn;
        }

        @Override
        public final Builder spendingLimitArn(String spendingLimitArn) {
            this.spendingLimitArn = spendingLimitArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSpendingLimit() {
            return this.spendingLimit;
        }

        public final void setSpendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
        }

        @Override
        public final Builder spendingLimit(String spendingLimit) {
            this.spendingLimit = spendingLimit;
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpendingLimitRequest build() {
            return new UpdateSpendingLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSpendingLimitRequest> {
        public Builder spendingLimitArn(String var1);

        public Builder clientToken(String var1);

        public Builder spendingLimit(String var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

