/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.CompressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScriptModeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScriptModeConfig> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryPoint").getter(ScriptModeConfig.getter(ScriptModeConfig::entryPoint)).setter(ScriptModeConfig.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(ScriptModeConfig.getter(ScriptModeConfig::s3Uri)).setter(ScriptModeConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("compressionType").getter(ScriptModeConfig.getter(ScriptModeConfig::compressionTypeAsString)).setter(ScriptModeConfig.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD, S3_URI_FIELD, COMPRESSION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScriptModeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryPoint;
    private final String s3Uri;
    private final String compressionType;

    private ScriptModeConfig(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.s3Uri = builder.s3Uri;
        this.compressionType = builder.compressionType;
    }

    public final String entryPoint() {
        return this.entryPoint;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptModeConfig)) {
            return false;
        }
        ScriptModeConfig other = (ScriptModeConfig)obj;
        return Objects.equals(this.entryPoint(), other.entryPoint()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScriptModeConfig").add("EntryPoint", (Object)this.entryPoint()).add("S3Uri", (Object)this.s3Uri()).add("CompressionType", (Object)this.compressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "compressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        map.put("compressionType", COMPRESSION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScriptModeConfig, T> g) {
        return obj -> g.apply((ScriptModeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryPoint;
        private String s3Uri;
        private String compressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptModeConfig model) {
            this.entryPoint(model.entryPoint);
            this.s3Uri(model.s3Uri);
            this.compressionType(model.compressionType);
        }

        public final String getEntryPoint() {
            return this.entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public ScriptModeConfig build() {
            return new ScriptModeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScriptModeConfig> {
        public Builder entryPoint(String var1);

        public Builder s3Uri(String var1);

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);
    }
}

