/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.QuantumTaskSummary;
import software.amazon.awssdk.services.braket.model.QuantumTaskSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchQuantumTasksResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, SearchQuantumTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchQuantumTasksResponse.getter(SearchQuantumTasksResponse::nextToken)).setter(SearchQuantumTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<QuantumTaskSummary>> QUANTUM_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("quantumTasks").getter(SearchQuantumTasksResponse.getter(SearchQuantumTasksResponse::quantumTasks)).setter(SearchQuantumTasksResponse.setter(Builder::quantumTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuantumTaskSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUANTUM_TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchQuantumTasksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<QuantumTaskSummary> quantumTasks;

    private SearchQuantumTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quantumTasks = builder.quantumTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQuantumTasks() {
        return this.quantumTasks != null && !(this.quantumTasks instanceof SdkAutoConstructList);
    }

    public final List<QuantumTaskSummary> quantumTasks() {
        return this.quantumTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuantumTasks() ? this.quantumTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQuantumTasksResponse)) {
            return false;
        }
        SearchQuantumTasksResponse other = (SearchQuantumTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQuantumTasks() == other.hasQuantumTasks() && Objects.equals(this.quantumTasks(), other.quantumTasks());
    }

    public final String toString() {
        return ToString.builder((String)"SearchQuantumTasksResponse").add("NextToken", (Object)this.nextToken()).add("QuantumTasks", this.hasQuantumTasks() ? this.quantumTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "quantumTasks": {
                return Optional.ofNullable(clazz.cast(this.quantumTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("quantumTasks", QUANTUM_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchQuantumTasksResponse, T> g) {
        return obj -> g.apply((SearchQuantumTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<QuantumTaskSummary> quantumTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQuantumTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.quantumTasks(model.quantumTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QuantumTaskSummary.Builder> getQuantumTasks() {
            List<QuantumTaskSummary.Builder> result = QuantumTaskSummaryListCopier.copyToBuilder(this.quantumTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuantumTasks(Collection<QuantumTaskSummary.BuilderImpl> quantumTasks) {
            this.quantumTasks = QuantumTaskSummaryListCopier.copyFromBuilder(quantumTasks);
        }

        @Override
        public final Builder quantumTasks(Collection<QuantumTaskSummary> quantumTasks) {
            this.quantumTasks = QuantumTaskSummaryListCopier.copy(quantumTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantumTasks(QuantumTaskSummary ... quantumTasks) {
            this.quantumTasks(Arrays.asList(quantumTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quantumTasks(Consumer<QuantumTaskSummary.Builder> ... quantumTasks) {
            this.quantumTasks(Stream.of(quantumTasks).map(c -> (QuantumTaskSummary)((QuantumTaskSummary.Builder)QuantumTaskSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchQuantumTasksResponse build() {
            return new SearchQuantumTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchQuantumTasksResponse> {
        public Builder nextToken(String var1);

        public Builder quantumTasks(Collection<QuantumTaskSummary> var1);

        public Builder quantumTasks(QuantumTaskSummary ... var1);

        public Builder quantumTasks(Consumer<QuantumTaskSummary.Builder> ... var1);
    }
}

