/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.braket.BraketAsyncClient;
import software.amazon.awssdk.services.braket.BraketAsyncClientBuilder;
import software.amazon.awssdk.services.braket.BraketServiceClientConfiguration;
import software.amazon.awssdk.services.braket.DefaultBraketAsyncClient;
import software.amazon.awssdk.services.braket.DefaultBraketBaseClientBuilder;
import software.amazon.awssdk.services.braket.endpoints.BraketEndpointProvider;

@SdkInternalApi
final class DefaultBraketAsyncClientBuilder
extends DefaultBraketBaseClientBuilder<BraketAsyncClientBuilder, BraketAsyncClient>
implements BraketAsyncClientBuilder {
    DefaultBraketAsyncClientBuilder() {
    }

    @Override
    public DefaultBraketAsyncClientBuilder endpointProvider(BraketEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BraketAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBraketAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BraketServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBraketAsyncClient client = new DefaultBraketAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BraketServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BraketServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

