/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.AlgorithmSpecification;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.CreateJobRequestInputDataConfigListCopier;
import software.amazon.awssdk.services.braket.model.DeviceConfig;
import software.amazon.awssdk.services.braket.model.HyperParametersCopier;
import software.amazon.awssdk.services.braket.model.InputFileConfig;
import software.amazon.awssdk.services.braket.model.InstanceConfig;
import software.amazon.awssdk.services.braket.model.JobCheckpointConfig;
import software.amazon.awssdk.services.braket.model.JobOutputDataConfig;
import software.amazon.awssdk.services.braket.model.JobStoppingCondition;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("algorithmSpecification").getter(CreateJobRequest.getter(CreateJobRequest::algorithmSpecification)).setter(CreateJobRequest.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmSpecification").build()}).build();
    private static final SdkField<JobCheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("checkpointConfig").getter(CreateJobRequest.getter(CreateJobRequest::checkpointConfig)).setter(CreateJobRequest.setter(Builder::checkpointConfig)).constructor(JobCheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkpointConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateJobRequest.getter(CreateJobRequest::clientToken)).setter(CreateJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DeviceConfig> DEVICE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceConfig").getter(CreateJobRequest.getter(CreateJobRequest::deviceConfig)).setter(CreateJobRequest.setter(Builder::deviceConfig)).constructor(DeviceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceConfig").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperParameters").getter(CreateJobRequest.getter(CreateJobRequest::hyperParameters)).setter(CreateJobRequest.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InputFileConfig>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputDataConfig").getter(CreateJobRequest.getter(CreateJobRequest::inputDataConfig)).setter(CreateJobRequest.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputFileConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceConfig> INSTANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceConfig").getter(CreateJobRequest.getter(CreateJobRequest::instanceConfig)).setter(CreateJobRequest.setter(Builder::instanceConfig)).constructor(InstanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfig").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateJobRequest.getter(CreateJobRequest::jobName)).setter(CreateJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<JobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(CreateJobRequest.getter(CreateJobRequest::outputDataConfig)).setter(CreateJobRequest.setter(Builder::outputDataConfig)).constructor(JobOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateJobRequest.getter(CreateJobRequest::roleArn)).setter(CreateJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<JobStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stoppingCondition").getter(CreateJobRequest.getter(CreateJobRequest::stoppingCondition)).setter(CreateJobRequest.setter(Builder::stoppingCondition)).constructor(JobStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateJobRequest.getter(CreateJobRequest::tags)).setter(CreateJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SPECIFICATION_FIELD, CHECKPOINT_CONFIG_FIELD, CLIENT_TOKEN_FIELD, DEVICE_CONFIG_FIELD, HYPER_PARAMETERS_FIELD, INPUT_DATA_CONFIG_FIELD, INSTANCE_CONFIG_FIELD, JOB_NAME_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private final AlgorithmSpecification algorithmSpecification;
    private final JobCheckpointConfig checkpointConfig;
    private final String clientToken;
    private final DeviceConfig deviceConfig;
    private final Map<String, String> hyperParameters;
    private final List<InputFileConfig> inputDataConfig;
    private final InstanceConfig instanceConfig;
    private final String jobName;
    private final JobOutputDataConfig outputDataConfig;
    private final String roleArn;
    private final JobStoppingCondition stoppingCondition;
    private final Map<String, String> tags;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.algorithmSpecification = builder.algorithmSpecification;
        this.checkpointConfig = builder.checkpointConfig;
        this.clientToken = builder.clientToken;
        this.deviceConfig = builder.deviceConfig;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.instanceConfig = builder.instanceConfig;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public final AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public final JobCheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DeviceConfig deviceConfig() {
        return this.deviceConfig;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<InputFileConfig> inputDataConfig() {
        return this.inputDataConfig;
    }

    public final InstanceConfig instanceConfig() {
        return this.instanceConfig;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final JobStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDataConfig() ? this.inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        return Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deviceConfig(), other.deviceConfig()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && this.hasInputDataConfig() == other.hasInputDataConfig() && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.instanceConfig(), other.instanceConfig()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateJobRequest").add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("ClientToken", (Object)this.clientToken()).add("DeviceConfig", (Object)this.deviceConfig()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("InputDataConfig", this.hasInputDataConfig() ? this.inputDataConfig() : null).add("InstanceConfig", (Object)this.instanceConfig()).add("JobName", (Object)this.jobName()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "checkpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deviceConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceConfig()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "inputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "instanceConfig": {
                return Optional.ofNullable(clazz.cast(this.instanceConfig()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "stoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private AlgorithmSpecification algorithmSpecification;
        private JobCheckpointConfig checkpointConfig;
        private String clientToken;
        private DeviceConfig deviceConfig;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<InputFileConfig> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private InstanceConfig instanceConfig;
        private String jobName;
        private JobOutputDataConfig outputDataConfig;
        private String roleArn;
        private JobStoppingCondition stoppingCondition;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            this.algorithmSpecification(model.algorithmSpecification);
            this.checkpointConfig(model.checkpointConfig);
            this.clientToken(model.clientToken);
            this.deviceConfig(model.deviceConfig);
            this.hyperParameters(model.hyperParameters);
            this.inputDataConfig(model.inputDataConfig);
            this.instanceConfig(model.instanceConfig);
            this.jobName(model.jobName);
            this.outputDataConfig(model.outputDataConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final JobCheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(JobCheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder checkpointConfig(JobCheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DeviceConfig.Builder getDeviceConfig() {
            return this.deviceConfig != null ? this.deviceConfig.toBuilder() : null;
        }

        public final void setDeviceConfig(DeviceConfig.BuilderImpl deviceConfig) {
            this.deviceConfig = deviceConfig != null ? deviceConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        @Transient
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final List<InputFileConfig.Builder> getInputDataConfig() {
            List<InputFileConfig.Builder> result = CreateJobRequestInputDataConfigListCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<InputFileConfig.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = CreateJobRequestInputDataConfigListCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        @Transient
        public final Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig) {
            this.inputDataConfig = CreateJobRequestInputDataConfigListCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputDataConfig(InputFileConfig ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<InputFileConfig.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (InputFileConfig)((InputFileConfig.Builder)InputFileConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfig.Builder getInstanceConfig() {
            return this.instanceConfig != null ? this.instanceConfig.toBuilder() : null;
        }

        public final void setInstanceConfig(InstanceConfig.BuilderImpl instanceConfig) {
            this.instanceConfig = instanceConfig != null ? instanceConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfig(InstanceConfig instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(JobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputDataConfig(JobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final JobStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(JobStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        @Transient
        public final Builder stoppingCondition(JobStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateJobRequest> {
        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder checkpointConfig(JobCheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<JobCheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((JobCheckpointConfig)((JobCheckpointConfig.Builder)JobCheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder deviceConfig(DeviceConfig var1);

        default public Builder deviceConfig(Consumer<DeviceConfig.Builder> deviceConfig) {
            return this.deviceConfig((DeviceConfig)((DeviceConfig.Builder)DeviceConfig.builder().applyMutation(deviceConfig)).build());
        }

        public Builder hyperParameters(Map<String, String> var1);

        public Builder inputDataConfig(Collection<InputFileConfig> var1);

        public Builder inputDataConfig(InputFileConfig ... var1);

        public Builder inputDataConfig(Consumer<InputFileConfig.Builder> ... var1);

        public Builder instanceConfig(InstanceConfig var1);

        default public Builder instanceConfig(Consumer<InstanceConfig.Builder> instanceConfig) {
            return this.instanceConfig((InstanceConfig)((InstanceConfig.Builder)InstanceConfig.builder().applyMutation(instanceConfig)).build());
        }

        public Builder jobName(String var1);

        public Builder outputDataConfig(JobOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<JobOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((JobOutputDataConfig)((JobOutputDataConfig.Builder)JobOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(JobStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<JobStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((JobStoppingCondition)((JobStoppingCondition.Builder)JobStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

