/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobOutputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobOutputDataConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(JobOutputDataConfig.getter(JobOutputDataConfig::kmsKeyId)).setter(JobOutputDataConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Path").getter(JobOutputDataConfig.getter(JobOutputDataConfig::s3Path)).setter(JobOutputDataConfig.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, S3_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String s3Path;

    private JobOutputDataConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3Path = builder.s3Path;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3Path() {
        return this.s3Path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOutputDataConfig)) {
            return false;
        }
        JobOutputDataConfig other = (JobOutputDataConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3Path(), other.s3Path());
    }

    public final String toString() {
        return ToString.builder((String)"JobOutputDataConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("S3Path", (Object)this.s3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "s3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobOutputDataConfig, T> g) {
        return obj -> g.apply((JobOutputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String s3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOutputDataConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.s3Path(model.s3Path);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        @Transient
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public JobOutputDataConfig build() {
            return new JobOutputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobOutputDataConfig> {
        public Builder kmsKeyId(String var1);

        public Builder s3Path(String var1);
    }
}

