/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeviceType {
    OFFLINE("OFFLINE"),
    ONLINE("ONLINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceType> knownValues() {
        return Stream.of(DeviceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

