/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeviceStatus {
    QPU("QPU"),
    SIMULATOR("SIMULATOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceStatus> knownValues() {
        return Stream.of(DeviceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

