/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.billingconductor.model.AccountGrouping;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ComputationPreference;
import software.amazon.awssdk.services.billingconductor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBillingGroupRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, CreateBillingGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::clientToken)).setter(CreateBillingGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::name)).setter(CreateBillingGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountGrouping").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::accountGrouping)).setter(CreateBillingGroupRequest.setter(Builder::accountGrouping)).constructor(AccountGrouping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()}).build();
    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputationPreference").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::computationPreference)).setter(CreateBillingGroupRequest.setter(Builder::computationPreference)).constructor(ComputationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountId").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::primaryAccountId)).setter(CreateBillingGroupRequest.setter(Builder::primaryAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::description)).setter(CreateBillingGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateBillingGroupRequest.getter(CreateBillingGroupRequest::tags)).setter(CreateBillingGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, ACCOUNT_GROUPING_FIELD, COMPUTATION_PREFERENCE_FIELD, PRIMARY_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBillingGroupRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String name;
    private final AccountGrouping accountGrouping;
    private final ComputationPreference computationPreference;
    private final String primaryAccountId;
    private final String description;
    private final Map<String, String> tags;

    private CreateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.accountGrouping = builder.accountGrouping;
        this.computationPreference = builder.computationPreference;
        this.primaryAccountId = builder.primaryAccountId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final AccountGrouping accountGrouping() {
        return this.accountGrouping;
    }

    public final ComputationPreference computationPreference() {
        return this.computationPreference;
    }

    public final String primaryAccountId() {
        return this.primaryAccountId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGrouping());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingGroupRequest)) {
            return false;
        }
        CreateBillingGroupRequest other = (CreateBillingGroupRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.accountGrouping(), other.accountGrouping()) && Objects.equals(this.computationPreference(), other.computationPreference()) && Objects.equals(this.primaryAccountId(), other.primaryAccountId()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBillingGroupRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountGrouping", (Object)this.accountGrouping()).add("ComputationPreference", (Object)this.computationPreference()).add("PrimaryAccountId", (Object)this.primaryAccountId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AccountGrouping": {
                return Optional.ofNullable(clazz.cast(this.accountGrouping()));
            }
            case "ComputationPreference": {
                return Optional.ofNullable(clazz.cast(this.computationPreference()));
            }
            case "PrimaryAccountId": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AccountGrouping", ACCOUNT_GROUPING_FIELD);
        map.put("ComputationPreference", COMPUTATION_PREFERENCE_FIELD);
        map.put("PrimaryAccountId", PRIMARY_ACCOUNT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingGroupRequest, T> g) {
        return obj -> g.apply((CreateBillingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private AccountGrouping accountGrouping;
        private ComputationPreference computationPreference;
        private String primaryAccountId;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingGroupRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.accountGrouping(model.accountGrouping);
            this.computationPreference(model.computationPreference);
            this.primaryAccountId(model.primaryAccountId);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AccountGrouping.Builder getAccountGrouping() {
            return this.accountGrouping != null ? this.accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(AccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(AccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return this.computationPreference != null ? this.computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final String getPrimaryAccountId() {
            return this.primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillingGroupRequest build() {
            return new CreateBillingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBillingGroupRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder accountGrouping(AccountGrouping var1);

        default public Builder accountGrouping(Consumer<AccountGrouping.Builder> accountGrouping) {
            return this.accountGrouping((AccountGrouping)((AccountGrouping.Builder)AccountGrouping.builder().applyMutation(accountGrouping)).build());
        }

        public Builder computationPreference(ComputationPreference var1);

        default public Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return this.computationPreference((ComputationPreference)((ComputationPreference.Builder)ComputationPreference.builder().applyMutation(computationPreference)).build());
        }

        public Builder primaryAccountId(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

