/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportElement;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;

public class ListBillingGroupCostReportsIterable
implements SdkIterable<ListBillingGroupCostReportsResponse> {
    private final BillingconductorClient client;
    private final ListBillingGroupCostReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillingGroupCostReportsIterable(BillingconductorClient client, ListBillingGroupCostReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillingGroupCostReportsResponseFetcher();
    }

    public Iterator<ListBillingGroupCostReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillingGroupCostReportElement> billingGroupCostReports() {
        Function<ListBillingGroupCostReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingGroupCostReports() != null) {
                return response.billingGroupCostReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillingGroupCostReportsResponseFetcher
    implements SyncPageFetcher<ListBillingGroupCostReportsResponse> {
        private ListBillingGroupCostReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingGroupCostReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillingGroupCostReportsResponse nextPage(ListBillingGroupCostReportsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingGroupCostReportsIterable.this.client.listBillingGroupCostReports(ListBillingGroupCostReportsIterable.this.firstRequest);
            }
            return ListBillingGroupCostReportsIterable.this.client.listBillingGroupCostReports((ListBillingGroupCostReportsRequest)((Object)ListBillingGroupCostReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

