/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemChargeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomLineItemResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, UpdateCustomLineItemResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::arn)).setter(UpdateCustomLineItemResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingGroupArn").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::billingGroupArn)).setter(UpdateCustomLineItemResponse.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::name)).setter(UpdateCustomLineItemResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::description)).setter(UpdateCustomLineItemResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChargeDetails").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::chargeDetails)).setter(UpdateCustomLineItemResponse.setter(Builder::chargeDetails)).constructor(ListCustomLineItemChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::lastModifiedTime)).setter(UpdateCustomLineItemResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssociationSize").getter(UpdateCustomLineItemResponse.getter(UpdateCustomLineItemResponse::associationSize)).setter(UpdateCustomLineItemResponse.setter(Builder::associationSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BILLING_GROUP_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CHARGE_DETAILS_FIELD, LAST_MODIFIED_TIME_FIELD, ASSOCIATION_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCustomLineItemResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String billingGroupArn;
    private final String name;
    private final String description;
    private final ListCustomLineItemChargeDetails chargeDetails;
    private final Long lastModifiedTime;
    private final Long associationSize;

    private UpdateCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.billingGroupArn = builder.billingGroupArn;
        this.name = builder.name;
        this.description = builder.description;
        this.chargeDetails = builder.chargeDetails;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
    }

    public final String arn() {
        return this.arn;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ListCustomLineItemChargeDetails chargeDetails() {
        return this.chargeDetails;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Long associationSize() {
        return this.associationSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemResponse)) {
            return false;
        }
        UpdateCustomLineItemResponse other = (UpdateCustomLineItemResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.chargeDetails(), other.chargeDetails()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.associationSize(), other.associationSize());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomLineItemResponse").add("Arn", (Object)this.arn()).add("BillingGroupArn", (Object)this.billingGroupArn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ChargeDetails", (Object)this.chargeDetails()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("AssociationSize", (Object)this.associationSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BillingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ChargeDetails": {
                return Optional.ofNullable(clazz.cast(this.chargeDetails()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "AssociationSize": {
                return Optional.ofNullable(clazz.cast(this.associationSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AssociationSize", ASSOCIATION_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemResponse, T> g) {
        return obj -> g.apply((UpdateCustomLineItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String billingGroupArn;
        private String name;
        private String description;
        private ListCustomLineItemChargeDetails chargeDetails;
        private Long lastModifiedTime;
        private Long associationSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemResponse model) {
            super(model);
            this.arn(model.arn);
            this.billingGroupArn(model.billingGroupArn);
            this.name(model.name);
            this.description(model.description);
            this.chargeDetails(model.chargeDetails);
            this.lastModifiedTime(model.lastModifiedTime);
            this.associationSize(model.associationSize);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return this.chargeDetails != null ? this.chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return this.associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        @Override
        public UpdateCustomLineItemResponse build() {
            return new UpdateCustomLineItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomLineItemResponse> {
        public Builder arn(String var1);

        public Builder billingGroupArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder chargeDetails(ListCustomLineItemChargeDetails var1);

        default public Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return this.chargeDetails((ListCustomLineItemChargeDetails)((ListCustomLineItemChargeDetails.Builder)ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails)).build());
        }

        public Builder lastModifiedTime(Long var1);

        public Builder associationSize(Long var1);
    }
}

