/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportElement;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;

public class ListBillingGroupCostReportsPublisher
implements SdkPublisher<ListBillingGroupCostReportsResponse> {
    private final BillingconductorAsyncClient client;
    private final ListBillingGroupCostReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillingGroupCostReportsPublisher(BillingconductorAsyncClient client, ListBillingGroupCostReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillingGroupCostReportsPublisher(BillingconductorAsyncClient client, ListBillingGroupCostReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillingGroupCostReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillingGroupCostReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillingGroupCostReportElement> billingGroupCostReports() {
        Function<ListBillingGroupCostReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingGroupCostReports() != null) {
                return response.billingGroupCostReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillingGroupCostReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillingGroupCostReportsResponseFetcher
    implements AsyncPageFetcher<ListBillingGroupCostReportsResponse> {
        private ListBillingGroupCostReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillingGroupCostReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillingGroupCostReportsResponse> nextPage(ListBillingGroupCostReportsResponse previousPage) {
            if (previousPage == null) {
                return ListBillingGroupCostReportsPublisher.this.client.listBillingGroupCostReports(ListBillingGroupCostReportsPublisher.this.firstRequest);
            }
            return ListBillingGroupCostReportsPublisher.this.client.listBillingGroupCostReports((ListBillingGroupCostReportsRequest)((Object)ListBillingGroupCostReportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

