/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAssociationsListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAssociationsListElement> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountAssociationsListElement.getter(AccountAssociationsListElement::accountId)).setter(AccountAssociationsListElement.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingGroupArn").getter(AccountAssociationsListElement.getter(AccountAssociationsListElement::billingGroupArn)).setter(AccountAssociationsListElement.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(AccountAssociationsListElement.getter(AccountAssociationsListElement::accountName)).setter(AccountAssociationsListElement.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> ACCOUNT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountEmail").getter(AccountAssociationsListElement.getter(AccountAssociationsListElement::accountEmail)).setter(AccountAssociationsListElement.setter(Builder::accountEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BILLING_GROUP_ARN_FIELD, ACCOUNT_NAME_FIELD, ACCOUNT_EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountAssociationsListElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String billingGroupArn;
    private final String accountName;
    private final String accountEmail;

    private AccountAssociationsListElement(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.billingGroupArn = builder.billingGroupArn;
        this.accountName = builder.accountName;
        this.accountEmail = builder.accountEmail;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final String accountEmail() {
        return this.accountEmail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountEmail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssociationsListElement)) {
            return false;
        }
        AccountAssociationsListElement other = (AccountAssociationsListElement)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.accountEmail(), other.accountEmail());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAssociationsListElement").add("AccountId", (Object)this.accountId()).add("BillingGroupArn", (Object)this.billingGroupArn()).add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountEmail", (Object)(this.accountEmail() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BillingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "AccountEmail": {
                return Optional.ofNullable(clazz.cast(this.accountEmail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        map.put("AccountEmail", ACCOUNT_EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAssociationsListElement, T> g) {
        return obj -> g.apply((AccountAssociationsListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String billingGroupArn;
        private String accountName;
        private String accountEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssociationsListElement model) {
            this.accountId(model.accountId);
            this.billingGroupArn(model.billingGroupArn);
            this.accountName(model.accountName);
            this.accountEmail(model.accountEmail);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getAccountEmail() {
            return this.accountEmail;
        }

        public final void setAccountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
        }

        @Override
        public final Builder accountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
            return this;
        }

        public AccountAssociationsListElement build() {
            return new AccountAssociationsListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAssociationsListElement> {
        public Builder accountId(String var1);

        public Builder billingGroupArn(String var1);

        public Builder accountName(String var1);

        public Builder accountEmail(String var1);
    }
}

