/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatus;
import software.amazon.awssdk.services.billingconductor.model.ComputationPreference;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupAccountGrouping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingGroupListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingGroupListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BillingGroupListElement.getter(BillingGroupListElement::name)).setter(BillingGroupListElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BillingGroupListElement.getter(BillingGroupListElement::arn)).setter(BillingGroupListElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(BillingGroupListElement.getter(BillingGroupListElement::description)).setter(BillingGroupListElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountId").getter(BillingGroupListElement.getter(BillingGroupListElement::primaryAccountId)).setter(BillingGroupListElement.setter(Builder::primaryAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()}).build();
    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputationPreference").getter(BillingGroupListElement.getter(BillingGroupListElement::computationPreference)).setter(BillingGroupListElement.setter(Builder::computationPreference)).constructor(ComputationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(BillingGroupListElement.getter(BillingGroupListElement::size)).setter(BillingGroupListElement.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTime").getter(BillingGroupListElement.getter(BillingGroupListElement::creationTime)).setter(BillingGroupListElement.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(BillingGroupListElement.getter(BillingGroupListElement::lastModifiedTime)).setter(BillingGroupListElement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BillingGroupListElement.getter(BillingGroupListElement::statusAsString)).setter(BillingGroupListElement.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(BillingGroupListElement.getter(BillingGroupListElement::statusReason)).setter(BillingGroupListElement.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<ListBillingGroupAccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountGrouping").getter(BillingGroupListElement.getter(BillingGroupListElement::accountGrouping)).setter(BillingGroupListElement.setter(Builder::accountGrouping)).constructor(ListBillingGroupAccountGrouping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DESCRIPTION_FIELD, PRIMARY_ACCOUNT_ID_FIELD, COMPUTATION_PREFERENCE_FIELD, SIZE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_GROUPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("PrimaryAccountId", PRIMARY_ACCOUNT_ID_FIELD);
            this.put("ComputationPreference", COMPUTATION_PREFERENCE_FIELD);
            this.put("Size", SIZE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
            this.put("AccountGrouping", ACCOUNT_GROUPING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String description;
    private final String primaryAccountId;
    private final ComputationPreference computationPreference;
    private final Long size;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final String status;
    private final String statusReason;
    private final ListBillingGroupAccountGrouping accountGrouping;

    private BillingGroupListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.primaryAccountId = builder.primaryAccountId;
        this.computationPreference = builder.computationPreference;
        this.size = builder.size;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGrouping = builder.accountGrouping;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String primaryAccountId() {
        return this.primaryAccountId;
    }

    public final ComputationPreference computationPreference() {
        return this.computationPreference;
    }

    public final Long size() {
        return this.size;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final ListBillingGroupAccountGrouping accountGrouping() {
        return this.accountGrouping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGrouping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingGroupListElement)) {
            return false;
        }
        BillingGroupListElement other = (BillingGroupListElement)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.primaryAccountId(), other.primaryAccountId()) && Objects.equals(this.computationPreference(), other.computationPreference()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.accountGrouping(), other.accountGrouping());
    }

    public final String toString() {
        return ToString.builder((String)"BillingGroupListElement").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Arn", (Object)this.arn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimaryAccountId", (Object)this.primaryAccountId()).add("ComputationPreference", (Object)this.computationPreference()).add("Size", (Object)this.size()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AccountGrouping", (Object)this.accountGrouping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PrimaryAccountId": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountId()));
            }
            case "ComputationPreference": {
                return Optional.ofNullable(clazz.cast(this.computationPreference()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "AccountGrouping": {
                return Optional.ofNullable(clazz.cast(this.accountGrouping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BillingGroupListElement, T> g) {
        return obj -> g.apply((BillingGroupListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private String primaryAccountId;
        private ComputationPreference computationPreference;
        private Long size;
        private Long creationTime;
        private Long lastModifiedTime;
        private String status;
        private String statusReason;
        private ListBillingGroupAccountGrouping accountGrouping;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingGroupListElement model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.primaryAccountId(model.primaryAccountId);
            this.computationPreference(model.computationPreference);
            this.size(model.size);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.accountGrouping(model.accountGrouping);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPrimaryAccountId() {
            return this.primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return this.computationPreference != null ? this.computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final ListBillingGroupAccountGrouping.Builder getAccountGrouping() {
            return this.accountGrouping != null ? this.accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(ListBillingGroupAccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(ListBillingGroupAccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        public BillingGroupListElement build() {
            return new BillingGroupListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingGroupListElement> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder primaryAccountId(String var1);

        public Builder computationPreference(ComputationPreference var1);

        default public Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return this.computationPreference((ComputationPreference)((ComputationPreference.Builder)ComputationPreference.builder().applyMutation(computationPreference)).build());
        }

        public Builder size(Long var1);

        public Builder creationTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder status(String var1);

        public Builder status(BillingGroupStatus var1);

        public Builder statusReason(String var1);

        public Builder accountGrouping(ListBillingGroupAccountGrouping var1);

        default public Builder accountGrouping(Consumer<ListBillingGroupAccountGrouping.Builder> accountGrouping) {
            return this.accountGrouping((ListBillingGroupAccountGrouping)((ListBillingGroupAccountGrouping.Builder)ListBillingGroupAccountGrouping.builder().applyMutation(accountGrouping)).build());
        }
    }
}

