/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemBillingPeriodRange;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomLineItemRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, CreateCustomLineItemRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::clientToken)).setter(CreateCustomLineItemRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::name)).setter(CreateCustomLineItemRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::description)).setter(CreateCustomLineItemRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingGroupArn").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::billingGroupArn)).setter(CreateCustomLineItemRequest.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()}).build();
    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriodRange").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::billingPeriodRange)).setter(CreateCustomLineItemRequest.setter(Builder::billingPeriodRange)).constructor(CustomLineItemBillingPeriodRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::tags)).setter(CreateCustomLineItemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChargeDetails").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::chargeDetails)).setter(CreateCustomLineItemRequest.setter(Builder::chargeDetails)).constructor(CustomLineItemChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CreateCustomLineItemRequest.getter(CreateCustomLineItemRequest::accountId)).setter(CreateCustomLineItemRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, BILLING_GROUP_ARN_FIELD, BILLING_PERIOD_RANGE_FIELD, TAGS_FIELD, CHARGE_DETAILS_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
            this.put("BillingPeriodRange", BILLING_PERIOD_RANGE_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ChargeDetails", CHARGE_DETAILS_FIELD);
            this.put("AccountId", ACCOUNT_ID_FIELD);
        }
    });
    private final String clientToken;
    private final String name;
    private final String description;
    private final String billingGroupArn;
    private final CustomLineItemBillingPeriodRange billingPeriodRange;
    private final Map<String, String> tags;
    private final CustomLineItemChargeDetails chargeDetails;
    private final String accountId;

    private CreateCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.billingGroupArn = builder.billingGroupArn;
        this.billingPeriodRange = builder.billingPeriodRange;
        this.tags = builder.tags;
        this.chargeDetails = builder.chargeDetails;
        this.accountId = builder.accountId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return this.billingPeriodRange;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CustomLineItemChargeDetails chargeDetails() {
        return this.chargeDetails;
    }

    public final String accountId() {
        return this.accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriodRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLineItemRequest)) {
            return false;
        }
        CreateCustomLineItemRequest other = (CreateCustomLineItemRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.billingPeriodRange(), other.billingPeriodRange()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.chargeDetails(), other.chargeDetails()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomLineItemRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("BillingGroupArn", (Object)this.billingGroupArn()).add("BillingPeriodRange", (Object)this.billingPeriodRange()).add("Tags", this.hasTags() ? this.tags() : null).add("ChargeDetails", (Object)this.chargeDetails()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BillingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "BillingPeriodRange": {
                return Optional.ofNullable(clazz.cast(this.billingPeriodRange()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ChargeDetails": {
                return Optional.ofNullable(clazz.cast(this.chargeDetails()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLineItemRequest, T> g) {
        return obj -> g.apply((CreateCustomLineItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private String description;
        private String billingGroupArn;
        private CustomLineItemBillingPeriodRange billingPeriodRange;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private CustomLineItemChargeDetails chargeDetails;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLineItemRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.billingGroupArn(model.billingGroupArn);
            this.billingPeriodRange(model.billingPeriodRange);
            this.tags(model.tags);
            this.chargeDetails(model.chargeDetails);
            this.accountId(model.accountId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return this.billingPeriodRange != null ? this.billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final CustomLineItemChargeDetails.Builder getChargeDetails() {
            return this.chargeDetails != null ? this.chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(CustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(CustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLineItemRequest build() {
            return new CreateCustomLineItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomLineItemRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder billingGroupArn(String var1);

        public Builder billingPeriodRange(CustomLineItemBillingPeriodRange var1);

        default public Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return this.billingPeriodRange((CustomLineItemBillingPeriodRange)((CustomLineItemBillingPeriodRange.Builder)CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder chargeDetails(CustomLineItemChargeDetails var1);

        default public Builder chargeDetails(Consumer<CustomLineItemChargeDetails.Builder> chargeDetails) {
            return this.chargeDetails((CustomLineItemChargeDetails)((CustomLineItemChargeDetails.Builder)CustomLineItemChargeDetails.builder().applyMutation(chargeDetails)).build());
        }

        public Builder accountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

