/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemBatchAssociationsListCopier;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemBillingPeriodRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateResourcesToCustomLineItemRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(BatchAssociateResourcesToCustomLineItemRequest.getter(BatchAssociateResourcesToCustomLineItemRequest::targetArn)).setter(BatchAssociateResourcesToCustomLineItemRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArns").getter(BatchAssociateResourcesToCustomLineItemRequest.getter(BatchAssociateResourcesToCustomLineItemRequest::resourceArns)).setter(BatchAssociateResourcesToCustomLineItemRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriodRange").getter(BatchAssociateResourcesToCustomLineItemRequest.getter(BatchAssociateResourcesToCustomLineItemRequest::billingPeriodRange)).setter(BatchAssociateResourcesToCustomLineItemRequest.setter(Builder::billingPeriodRange)).constructor(CustomLineItemBillingPeriodRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, RESOURCE_ARNS_FIELD, BILLING_PERIOD_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TargetArn", TARGET_ARN_FIELD);
            this.put("ResourceArns", RESOURCE_ARNS_FIELD);
            this.put("BillingPeriodRange", BILLING_PERIOD_RANGE_FIELD);
        }
    });
    private final String targetArn;
    private final List<String> resourceArns;
    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private BatchAssociateResourcesToCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.resourceArns = builder.resourceArns;
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return this.billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriodRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourcesToCustomLineItemRequest)) {
            return false;
        }
        BatchAssociateResourcesToCustomLineItemRequest other = (BatchAssociateResourcesToCustomLineItemRequest)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && Objects.equals(this.billingPeriodRange(), other.billingPeriodRange());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateResourcesToCustomLineItemRequest").add("TargetArn", (Object)this.targetArn()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("BillingPeriodRange", (Object)this.billingPeriodRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "ResourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "BillingPeriodRange": {
                return Optional.ofNullable(clazz.cast(this.billingPeriodRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateResourcesToCustomLineItemRequest, T> g) {
        return obj -> g.apply((BatchAssociateResourcesToCustomLineItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String targetArn;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateResourcesToCustomLineItemRequest model) {
            super(model);
            this.targetArn(model.targetArn);
            this.resourceArns(model.resourceArns);
            this.billingPeriodRange(model.billingPeriodRange);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = CustomLineItemBatchAssociationsListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = CustomLineItemBatchAssociationsListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return this.billingPeriodRange != null ? this.billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateResourcesToCustomLineItemRequest build() {
            return new BatchAssociateResourcesToCustomLineItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemRequest> {
        public Builder targetArn(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder billingPeriodRange(CustomLineItemBillingPeriodRange var1);

        default public Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return this.billingPeriodRange((CustomLineItemBillingPeriodRange)((CustomLineItemBillingPeriodRange.Builder)CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

