/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupArnListCopier;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatus;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListBillingGroupsFilter> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Arns").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::arns)).setter(ListBillingGroupsFilter.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::pricingPlan)).setter(ListBillingGroupsFilter.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statuses").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::statusesAsStrings)).setter(ListBillingGroupsFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_ASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoAssociate").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::autoAssociate)).setter(ListBillingGroupsFilter.setter(Builder::autoAssociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssociate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD, PRICING_PLAN_FIELD, STATUSES_FIELD, AUTO_ASSOCIATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> arns;
    private final String pricingPlan;
    private final List<String> statuses;
    private final Boolean autoAssociate;

    private ListBillingGroupsFilter(BuilderImpl builder) {
        this.arns = builder.arns;
        this.pricingPlan = builder.pricingPlan;
        this.statuses = builder.statuses;
        this.autoAssociate = builder.autoAssociate;
    }

    public final boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public final List<String> arns() {
        return this.arns;
    }

    public final String pricingPlan() {
        return this.pricingPlan;
    }

    public final List<BillingGroupStatus> statuses() {
        return BillingGroupStatusListCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final Boolean autoAssociate() {
        return this.autoAssociate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArns() ? this.arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssociate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsFilter)) {
            return false;
        }
        ListBillingGroupsFilter other = (ListBillingGroupsFilter)obj;
        return this.hasArns() == other.hasArns() && Objects.equals(this.arns(), other.arns()) && Objects.equals(this.pricingPlan(), other.pricingPlan()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && Objects.equals(this.autoAssociate(), other.autoAssociate());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingGroupsFilter").add("Arns", this.hasArns() ? this.arns() : null).add("PricingPlan", (Object)this.pricingPlan()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("AutoAssociate", (Object)this.autoAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlan()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "AutoAssociate": {
                return Optional.ofNullable(clazz.cast(this.autoAssociate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();
        private String pricingPlan;
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsFilter model) {
            this.arns(model.arns);
            this.pricingPlan(model.pricingPlan);
            this.statusesWithStrings(model.statuses);
            this.autoAssociate(model.autoAssociate);
        }

        public final Collection<String> getArns() {
            if (this.arns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = BillingGroupStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<BillingGroupStatus> statuses) {
            this.statuses = BillingGroupStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(BillingGroupStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Boolean getAutoAssociate() {
            return this.autoAssociate;
        }

        public final void setAutoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
        }

        @Override
        public final Builder autoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
            return this;
        }

        public ListBillingGroupsFilter build() {
            return new ListBillingGroupsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupsFilter> {
        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);

        public Builder pricingPlan(String var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<BillingGroupStatus> var1);

        public Builder statuses(BillingGroupStatus ... var1);

        public Builder autoAssociate(Boolean var1);
    }
}

