/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.AccountIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountGrouping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountGrouping> {
    private static final SdkField<List<String>> LINKED_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkedAccountIds").getter(AccountGrouping.getter(AccountGrouping::linkedAccountIds)).setter(AccountGrouping.setter(Builder::linkedAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_ASSOCIATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoAssociate").getter(AccountGrouping.getter(AccountGrouping::autoAssociate)).setter(AccountGrouping.setter(Builder::autoAssociate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssociate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNT_IDS_FIELD, AUTO_ASSOCIATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> linkedAccountIds;
    private final Boolean autoAssociate;

    private AccountGrouping(BuilderImpl builder) {
        this.linkedAccountIds = builder.linkedAccountIds;
        this.autoAssociate = builder.autoAssociate;
    }

    public final boolean hasLinkedAccountIds() {
        return this.linkedAccountIds != null && !(this.linkedAccountIds instanceof SdkAutoConstructList);
    }

    public final List<String> linkedAccountIds() {
        return this.linkedAccountIds;
    }

    public final Boolean autoAssociate() {
        return this.autoAssociate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedAccountIds() ? this.linkedAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssociate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountGrouping)) {
            return false;
        }
        AccountGrouping other = (AccountGrouping)obj;
        return this.hasLinkedAccountIds() == other.hasLinkedAccountIds() && Objects.equals(this.linkedAccountIds(), other.linkedAccountIds()) && Objects.equals(this.autoAssociate(), other.autoAssociate());
    }

    public final String toString() {
        return ToString.builder((String)"AccountGrouping").add("LinkedAccountIds", this.hasLinkedAccountIds() ? this.linkedAccountIds() : null).add("AutoAssociate", (Object)this.autoAssociate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkedAccountIds": {
                return Optional.ofNullable(clazz.cast(this.linkedAccountIds()));
            }
            case "AutoAssociate": {
                return Optional.ofNullable(clazz.cast(this.autoAssociate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountGrouping, T> g) {
        return obj -> g.apply((AccountGrouping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> linkedAccountIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoAssociate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountGrouping model) {
            this.linkedAccountIds(model.linkedAccountIds);
            this.autoAssociate(model.autoAssociate);
        }

        public final Collection<String> getLinkedAccountIds() {
            if (this.linkedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedAccountIds;
        }

        public final void setLinkedAccountIds(Collection<String> linkedAccountIds) {
            this.linkedAccountIds = AccountIdListCopier.copy(linkedAccountIds);
        }

        @Override
        public final Builder linkedAccountIds(Collection<String> linkedAccountIds) {
            this.linkedAccountIds = AccountIdListCopier.copy(linkedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccountIds(String ... linkedAccountIds) {
            this.linkedAccountIds(Arrays.asList(linkedAccountIds));
            return this;
        }

        public final Boolean getAutoAssociate() {
            return this.autoAssociate;
        }

        public final void setAutoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
        }

        @Override
        public final Builder autoAssociate(Boolean autoAssociate) {
            this.autoAssociate = autoAssociate;
            return this;
        }

        public AccountGrouping build() {
            return new AccountGrouping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountGrouping> {
        public Builder linkedAccountIds(Collection<String> var1);

        public Builder linkedAccountIds(String ... var1);

        public Builder autoAssociate(Boolean var1);
    }
}

