/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemAssociationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLineItemPercentageChargeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLineItemPercentageChargeDetails> {
    private static final SdkField<Double> PERCENTAGE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentageValue").getter(CustomLineItemPercentageChargeDetails.getter(CustomLineItemPercentageChargeDetails::percentageValue)).setter(CustomLineItemPercentageChargeDetails.setter(Builder::percentageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageValue").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedValues").getter(CustomLineItemPercentageChargeDetails.getter(CustomLineItemPercentageChargeDetails::associatedValues)).setter(CustomLineItemPercentageChargeDetails.setter(Builder::associatedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_VALUE_FIELD, ASSOCIATED_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double percentageValue;
    private final List<String> associatedValues;

    private CustomLineItemPercentageChargeDetails(BuilderImpl builder) {
        this.percentageValue = builder.percentageValue;
        this.associatedValues = builder.associatedValues;
    }

    public final Double percentageValue() {
        return this.percentageValue;
    }

    public final boolean hasAssociatedValues() {
        return this.associatedValues != null && !(this.associatedValues instanceof SdkAutoConstructList);
    }

    public final List<String> associatedValues() {
        return this.associatedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedValues() ? this.associatedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemPercentageChargeDetails)) {
            return false;
        }
        CustomLineItemPercentageChargeDetails other = (CustomLineItemPercentageChargeDetails)obj;
        return Objects.equals(this.percentageValue(), other.percentageValue()) && this.hasAssociatedValues() == other.hasAssociatedValues() && Objects.equals(this.associatedValues(), other.associatedValues());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLineItemPercentageChargeDetails").add("PercentageValue", (Object)this.percentageValue()).add("AssociatedValues", this.hasAssociatedValues() ? this.associatedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PercentageValue": {
                return Optional.ofNullable(clazz.cast(this.percentageValue()));
            }
            case "AssociatedValues": {
                return Optional.ofNullable(clazz.cast(this.associatedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemPercentageChargeDetails, T> g) {
        return obj -> g.apply((CustomLineItemPercentageChargeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double percentageValue;
        private List<String> associatedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemPercentageChargeDetails model) {
            this.percentageValue(model.percentageValue);
            this.associatedValues(model.associatedValues);
        }

        public final Double getPercentageValue() {
            return this.percentageValue;
        }

        public final void setPercentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
        }

        @Override
        public final Builder percentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
            return this;
        }

        public final Collection<String> getAssociatedValues() {
            if (this.associatedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedValues;
        }

        public final void setAssociatedValues(Collection<String> associatedValues) {
            this.associatedValues = CustomLineItemAssociationsListCopier.copy(associatedValues);
        }

        @Override
        public final Builder associatedValues(Collection<String> associatedValues) {
            this.associatedValues = CustomLineItemAssociationsListCopier.copy(associatedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedValues(String ... associatedValues) {
            this.associatedValues(Arrays.asList(associatedValues));
            return this;
        }

        public CustomLineItemPercentageChargeDetails build() {
            return new CustomLineItemPercentageChargeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLineItemPercentageChargeDetails> {
        public Builder percentageValue(Double var1);

        public Builder associatedValues(Collection<String> var1);

        public Builder associatedValues(String ... var1);
    }
}

