/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemType;
import software.amazon.awssdk.services.billingconductor.model.LineItemFilter;
import software.amazon.awssdk.services.billingconductor.model.LineItemFiltersListCopier;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemFlatChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemPercentageChargeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomLineItemChargeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCustomLineItemChargeDetails> {
    private static final SdkField<ListCustomLineItemFlatChargeDetails> FLAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Flat").getter(ListCustomLineItemChargeDetails.getter(ListCustomLineItemChargeDetails::flat)).setter(ListCustomLineItemChargeDetails.setter(Builder::flat)).constructor(ListCustomLineItemFlatChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flat").build()}).build();
    private static final SdkField<ListCustomLineItemPercentageChargeDetails> PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Percentage").getter(ListCustomLineItemChargeDetails.getter(ListCustomLineItemChargeDetails::percentage)).setter(ListCustomLineItemChargeDetails.setter(Builder::percentage)).constructor(ListCustomLineItemPercentageChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListCustomLineItemChargeDetails.getter(ListCustomLineItemChargeDetails::typeAsString)).setter(ListCustomLineItemChargeDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<LineItemFilter>> LINE_ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItemFilters").getter(ListCustomLineItemChargeDetails.getter(ListCustomLineItemChargeDetails::lineItemFilters)).setter(ListCustomLineItemChargeDetails.setter(Builder::lineItemFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAT_FIELD, PERCENTAGE_FIELD, TYPE_FIELD, LINE_ITEM_FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ListCustomLineItemFlatChargeDetails flat;
    private final ListCustomLineItemPercentageChargeDetails percentage;
    private final String type;
    private final List<LineItemFilter> lineItemFilters;

    private ListCustomLineItemChargeDetails(BuilderImpl builder) {
        this.flat = builder.flat;
        this.percentage = builder.percentage;
        this.type = builder.type;
        this.lineItemFilters = builder.lineItemFilters;
    }

    public final ListCustomLineItemFlatChargeDetails flat() {
        return this.flat;
    }

    public final ListCustomLineItemPercentageChargeDetails percentage() {
        return this.percentage;
    }

    public final CustomLineItemType type() {
        return CustomLineItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasLineItemFilters() {
        return this.lineItemFilters != null && !(this.lineItemFilters instanceof SdkAutoConstructList);
    }

    public final List<LineItemFilter> lineItemFilters() {
        return this.lineItemFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flat());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItemFilters() ? this.lineItemFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemChargeDetails)) {
            return false;
        }
        ListCustomLineItemChargeDetails other = (ListCustomLineItemChargeDetails)obj;
        return Objects.equals(this.flat(), other.flat()) && Objects.equals(this.percentage(), other.percentage()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasLineItemFilters() == other.hasLineItemFilters() && Objects.equals(this.lineItemFilters(), other.lineItemFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomLineItemChargeDetails").add("Flat", (Object)this.flat()).add("Percentage", (Object)this.percentage()).add("Type", (Object)this.typeAsString()).add("LineItemFilters", this.hasLineItemFilters() ? this.lineItemFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flat": {
                return Optional.ofNullable(clazz.cast(this.flat()));
            }
            case "Percentage": {
                return Optional.ofNullable(clazz.cast(this.percentage()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LineItemFilters": {
                return Optional.ofNullable(clazz.cast(this.lineItemFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemChargeDetails, T> g) {
        return obj -> g.apply((ListCustomLineItemChargeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ListCustomLineItemFlatChargeDetails flat;
        private ListCustomLineItemPercentageChargeDetails percentage;
        private String type;
        private List<LineItemFilter> lineItemFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemChargeDetails model) {
            this.flat(model.flat);
            this.percentage(model.percentage);
            this.type(model.type);
            this.lineItemFilters(model.lineItemFilters);
        }

        public final ListCustomLineItemFlatChargeDetails.Builder getFlat() {
            return this.flat != null ? this.flat.toBuilder() : null;
        }

        public final void setFlat(ListCustomLineItemFlatChargeDetails.BuilderImpl flat) {
            this.flat = flat != null ? flat.build() : null;
        }

        @Override
        public final Builder flat(ListCustomLineItemFlatChargeDetails flat) {
            this.flat = flat;
            return this;
        }

        public final ListCustomLineItemPercentageChargeDetails.Builder getPercentage() {
            return this.percentage != null ? this.percentage.toBuilder() : null;
        }

        public final void setPercentage(ListCustomLineItemPercentageChargeDetails.BuilderImpl percentage) {
            this.percentage = percentage != null ? percentage.build() : null;
        }

        @Override
        public final Builder percentage(ListCustomLineItemPercentageChargeDetails percentage) {
            this.percentage = percentage;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CustomLineItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<LineItemFilter.Builder> getLineItemFilters() {
            List<LineItemFilter.Builder> result = LineItemFiltersListCopier.copyToBuilder(this.lineItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemFilters(Collection<LineItemFilter.BuilderImpl> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copyFromBuilder(lineItemFilters);
        }

        @Override
        public final Builder lineItemFilters(Collection<LineItemFilter> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copy(lineItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(LineItemFilter ... lineItemFilters) {
            this.lineItemFilters(Arrays.asList(lineItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(Consumer<LineItemFilter.Builder> ... lineItemFilters) {
            this.lineItemFilters(Stream.of(lineItemFilters).map(c -> (LineItemFilter)((LineItemFilter.Builder)LineItemFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListCustomLineItemChargeDetails build() {
            return new ListCustomLineItemChargeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCustomLineItemChargeDetails> {
        public Builder flat(ListCustomLineItemFlatChargeDetails var1);

        default public Builder flat(Consumer<ListCustomLineItemFlatChargeDetails.Builder> flat) {
            return this.flat((ListCustomLineItemFlatChargeDetails)((ListCustomLineItemFlatChargeDetails.Builder)ListCustomLineItemFlatChargeDetails.builder().applyMutation(flat)).build());
        }

        public Builder percentage(ListCustomLineItemPercentageChargeDetails var1);

        default public Builder percentage(Consumer<ListCustomLineItemPercentageChargeDetails.Builder> percentage) {
            return this.percentage((ListCustomLineItemPercentageChargeDetails)((ListCustomLineItemPercentageChargeDetails.Builder)ListCustomLineItemPercentageChargeDetails.builder().applyMutation(percentage)).build());
        }

        public Builder type(String var1);

        public Builder type(CustomLineItemType var1);

        public Builder lineItemFilters(Collection<LineItemFilter> var1);

        public Builder lineItemFilters(LineItemFilter ... var1);

        public Builder lineItemFilters(Consumer<LineItemFilter.Builder> ... var1);
    }
}

