/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleScope;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleType;
import software.amazon.awssdk.services.billingconductor.model.UpdateTieringInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePricingRuleResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, UpdatePricingRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::arn)).setter(UpdatePricingRuleResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::name)).setter(UpdatePricingRuleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::description)).setter(UpdatePricingRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::scopeAsString)).setter(UpdatePricingRuleResponse.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::typeAsString)).setter(UpdatePricingRuleResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ModifierPercentage").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::modifierPercentage)).setter(UpdatePricingRuleResponse.setter(Builder::modifierPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::service)).setter(UpdatePricingRuleResponse.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Long> ASSOCIATED_PRICING_PLAN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssociatedPricingPlanCount").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::associatedPricingPlanCount)).setter(UpdatePricingRuleResponse.setter(Builder::associatedPricingPlanCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedPricingPlanCount").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::lastModifiedTime)).setter(UpdatePricingRuleResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> BILLING_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingEntity").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::billingEntity)).setter(UpdatePricingRuleResponse.setter(Builder::billingEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingEntity").build()}).build();
    private static final SdkField<UpdateTieringInput> TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tiering").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::tiering)).setter(UpdatePricingRuleResponse.setter(Builder::tiering)).constructor(UpdateTieringInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageType").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::usageType)).setter(UpdatePricingRuleResponse.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(UpdatePricingRuleResponse.getter(UpdatePricingRuleResponse::operation)).setter(UpdatePricingRuleResponse.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD, ASSOCIATED_PRICING_PLAN_COUNT_FIELD, LAST_MODIFIED_TIME_FIELD, BILLING_ENTITY_FIELD, TIERING_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD));
    private final String arn;
    private final String name;
    private final String description;
    private final String scope;
    private final String type;
    private final Double modifierPercentage;
    private final String service;
    private final Long associatedPricingPlanCount;
    private final Long lastModifiedTime;
    private final String billingEntity;
    private final UpdateTieringInput tiering;
    private final String usageType;
    private final String operation;

    private UpdatePricingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.associatedPricingPlanCount = builder.associatedPricingPlanCount;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.billingEntity = builder.billingEntity;
        this.tiering = builder.tiering;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final PricingRuleType type() {
        return PricingRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double modifierPercentage() {
        return this.modifierPercentage;
    }

    public final String service() {
        return this.service;
    }

    public final Long associatedPricingPlanCount() {
        return this.associatedPricingPlanCount;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String billingEntity() {
        return this.billingEntity;
    }

    public final UpdateTieringInput tiering() {
        return this.tiering;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedPricingPlanCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tiering());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePricingRuleResponse)) {
            return false;
        }
        UpdatePricingRuleResponse other = (UpdatePricingRuleResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.modifierPercentage(), other.modifierPercentage()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.associatedPricingPlanCount(), other.associatedPricingPlanCount()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.billingEntity(), other.billingEntity()) && Objects.equals(this.tiering(), other.tiering()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePricingRuleResponse").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scopeAsString()).add("Type", (Object)this.typeAsString()).add("ModifierPercentage", (Object)this.modifierPercentage()).add("Service", (Object)this.service()).add("AssociatedPricingPlanCount", (Object)this.associatedPricingPlanCount()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("BillingEntity", (Object)this.billingEntity()).add("Tiering", (Object)this.tiering()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ModifierPercentage": {
                return Optional.ofNullable(clazz.cast(this.modifierPercentage()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "AssociatedPricingPlanCount": {
                return Optional.ofNullable(clazz.cast(this.associatedPricingPlanCount()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "BillingEntity": {
                return Optional.ofNullable(clazz.cast(this.billingEntity()));
            }
            case "Tiering": {
                return Optional.ofNullable(clazz.cast(this.tiering()));
            }
            case "UsageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePricingRuleResponse, T> g) {
        return obj -> g.apply((UpdatePricingRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String scope;
        private String type;
        private Double modifierPercentage;
        private String service;
        private Long associatedPricingPlanCount;
        private Long lastModifiedTime;
        private String billingEntity;
        private UpdateTieringInput tiering;
        private String usageType;
        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePricingRuleResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.scope(model.scope);
            this.type(model.type);
            this.modifierPercentage(model.modifierPercentage);
            this.service(model.service);
            this.associatedPricingPlanCount(model.associatedPricingPlanCount);
            this.lastModifiedTime(model.lastModifiedTime);
            this.billingEntity(model.billingEntity);
            this.tiering(model.tiering);
            this.usageType(model.usageType);
            this.operation(model.operation);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return this.modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Long getAssociatedPricingPlanCount() {
            return this.associatedPricingPlanCount;
        }

        public final void setAssociatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
        }

        @Override
        public final Builder associatedPricingPlanCount(Long associatedPricingPlanCount) {
            this.associatedPricingPlanCount = associatedPricingPlanCount;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getBillingEntity() {
            return this.billingEntity;
        }

        public final void setBillingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
        }

        @Override
        public final Builder billingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        public final UpdateTieringInput.Builder getTiering() {
            return this.tiering != null ? this.tiering.toBuilder() : null;
        }

        public final void setTiering(UpdateTieringInput.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(UpdateTieringInput tiering) {
            this.tiering = tiering;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public UpdatePricingRuleResponse build() {
            return new UpdatePricingRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePricingRuleResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder scope(String var1);

        public Builder scope(PricingRuleScope var1);

        public Builder type(String var1);

        public Builder type(PricingRuleType var1);

        public Builder modifierPercentage(Double var1);

        public Builder service(String var1);

        public Builder associatedPricingPlanCount(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder billingEntity(String var1);

        public Builder tiering(UpdateTieringInput var1);

        default public Builder tiering(Consumer<UpdateTieringInput.Builder> tiering) {
            return this.tiering((UpdateTieringInput)((UpdateTieringInput.Builder)UpdateTieringInput.builder().applyMutation(tiering)).build());
        }

        public Builder usageType(String var1);

        public Builder operation(String var1);
    }
}

