/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillingGroupRequest extends BillingconductorRequest implements
        ToCopyableBuilder<UpdateBillingGroupRequest.Builder, UpdateBillingGroupRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateBillingGroupRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateBillingGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateBillingGroupRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField
            .<ComputationPreference> builder(MarshallingType.SDK_POJO).memberName("ComputationPreference")
            .getter(getter(UpdateBillingGroupRequest::computationPreference)).setter(setter(Builder::computationPreference))
            .constructor(ComputationPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateBillingGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, COMPUTATION_PREFERENCE_FIELD, DESCRIPTION_FIELD));

    private final String arn;

    private final String name;

    private final String status;

    private final ComputationPreference computationPreference;

    private final String description;

    private UpdateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.computationPreference = builder.computationPreference;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the billing group being updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the billing group being updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the billing group. The names must be unique to each billing group.
     * </p>
     * 
     * @return The name of the billing group. The names must be unique to each billing group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the billing group. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the billing group. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the billing group. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the billing group. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
     * </p>
     * 
     * @return The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
     *         group.
     */
    public final ComputationPreference computationPreference() {
        return computationPreference;
    }

    /**
     * <p>
     * A description of the billing group.
     * </p>
     * 
     * @return A description of the billing group.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupRequest)) {
            return false;
        }
        UpdateBillingGroupRequest other = (UpdateBillingGroupRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(computationPreference(), other.computationPreference())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBillingGroupRequest").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("ComputationPreference", computationPreference())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ComputationPreference":
            return Optional.ofNullable(clazz.cast(computationPreference()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupRequest, T> g) {
        return obj -> g.apply((UpdateBillingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBillingGroupRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the billing group being updated.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the billing group being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the billing group. The names must be unique to each billing group.
         * </p>
         * 
         * @param name
         *        The name of the billing group. The names must be unique to each billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the billing group. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The status of the billing group. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the billing group. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The status of the billing group. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(BillingGroupStatus status);

        /**
         * <p>
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
         * group.
         * </p>
         * 
         * @param computationPreference
         *        The preferences and settings that will be used to compute the Amazon Web Services charges for a
         *        billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationPreference(ComputationPreference computationPreference);

        /**
         * <p>
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
         * group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationPreference.Builder} avoiding
         * the need to create one manually via {@link ComputationPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #computationPreference(ComputationPreference)}.
         * 
         * @param computationPreference
         *        a consumer that will call methods on {@link ComputationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationPreference(ComputationPreference)
         */
        default Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return computationPreference(ComputationPreference.builder().applyMutation(computationPreference).build());
        }

        /**
         * <p>
         * A description of the billing group.
         * </p>
         * 
         * @param description
         *        A description of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String status;

        private ComputationPreference computationPreference;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            status(model.status);
            computationPreference(model.computationPreference);
            description(model.description);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return computationPreference != null ? computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillingGroupRequest build() {
            return new UpdateBillingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
