/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomLineItemsRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, ListCustomLineItemsRequest> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingPeriod").getter(ListCustomLineItemsRequest.getter(ListCustomLineItemsRequest::billingPeriod)).setter(ListCustomLineItemsRequest.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCustomLineItemsRequest.getter(ListCustomLineItemsRequest::maxResults)).setter(ListCustomLineItemsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomLineItemsRequest.getter(ListCustomLineItemsRequest::nextToken)).setter(ListCustomLineItemsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<ListCustomLineItemsFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(ListCustomLineItemsRequest.getter(ListCustomLineItemsRequest::filters)).setter(ListCustomLineItemsRequest.setter(Builder::filters)).constructor(ListCustomLineItemsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));
    private final String billingPeriod;
    private final Integer maxResults;
    private final String nextToken;
    private final ListCustomLineItemsFilter filters;

    private ListCustomLineItemsRequest(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ListCustomLineItemsFilter filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemsRequest)) {
            return false;
        }
        ListCustomLineItemsRequest other = (ListCustomLineItemsRequest)((Object)obj);
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomLineItemsRequest").add("BillingPeriod", (Object)this.billingPeriod()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Filters", (Object)this.filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemsRequest, T> g) {
        return obj -> g.apply((ListCustomLineItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String billingPeriod;
        private Integer maxResults;
        private String nextToken;
        private ListCustomLineItemsFilter filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemsRequest model) {
            super(model);
            this.billingPeriod(model.billingPeriod);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ListCustomLineItemsFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ListCustomLineItemsFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListCustomLineItemsFilter filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomLineItemsRequest build() {
            return new ListCustomLineItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomLineItemsRequest> {
        public Builder billingPeriod(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(ListCustomLineItemsFilter var1);

        default public Builder filters(Consumer<ListCustomLineItemsFilter.Builder> filters) {
            return this.filters((ListCustomLineItemsFilter)((ListCustomLineItemsFilter.Builder)ListCustomLineItemsFilter.builder().applyMutation(filters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

