/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClientBuilder;
import software.amazon.awssdk.services.billingconductor.BillingconductorServiceClientConfiguration;
import software.amazon.awssdk.services.billingconductor.DefaultBillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.DefaultBillingconductorBaseClientBuilder;
import software.amazon.awssdk.services.billingconductor.endpoints.BillingconductorEndpointProvider;

@SdkInternalApi
final class DefaultBillingconductorAsyncClientBuilder
extends DefaultBillingconductorBaseClientBuilder<BillingconductorAsyncClientBuilder, BillingconductorAsyncClient>
implements BillingconductorAsyncClientBuilder {
    DefaultBillingconductorAsyncClientBuilder() {
    }

    @Override
    public DefaultBillingconductorAsyncClientBuilder endpointProvider(BillingconductorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BillingconductorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBillingconductorAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BillingconductorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBillingconductorAsyncClient client = new DefaultBillingconductorAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BillingconductorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BillingconductorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

