/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;

public class ListCustomLineItemVersionsIterable
implements SdkIterable<ListCustomLineItemVersionsResponse> {
    private final BillingconductorClient client;
    private final ListCustomLineItemVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomLineItemVersionsIterable(BillingconductorClient client, ListCustomLineItemVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomLineItemVersionsResponseFetcher();
    }

    public Iterator<ListCustomLineItemVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomLineItemVersionListElement> customLineItemVersions() {
        Function<ListCustomLineItemVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customLineItemVersions() != null) {
                return response.customLineItemVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomLineItemVersionsResponseFetcher
    implements SyncPageFetcher<ListCustomLineItemVersionsResponse> {
        private ListCustomLineItemVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomLineItemVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomLineItemVersionsResponse nextPage(ListCustomLineItemVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomLineItemVersionsIterable.this.client.listCustomLineItemVersions(ListCustomLineItemVersionsIterable.this.firstRequest);
            }
            return ListCustomLineItemVersionsIterable.this.client.listCustomLineItemVersions((ListCustomLineItemVersionsRequest)((Object)ListCustomLineItemVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

