/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement;
import software.amazon.awssdk.services.billingconductor.model.AssociateResourcesResponseListCopier;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAssociateResourcesToCustomLineItemResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemResponse> {
    private static final SdkField<List<AssociateResourceResponseElement>> SUCCESSFULLY_ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfullyAssociatedResources").getter(BatchAssociateResourcesToCustomLineItemResponse.getter(BatchAssociateResourcesToCustomLineItemResponse::successfullyAssociatedResources)).setter(BatchAssociateResourcesToCustomLineItemResponse.setter(Builder::successfullyAssociatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfullyAssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociateResourceResponseElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssociateResourceResponseElement>> FAILED_ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedAssociatedResources").getter(BatchAssociateResourcesToCustomLineItemResponse.getter(BatchAssociateResourcesToCustomLineItemResponse::failedAssociatedResources)).setter(BatchAssociateResourcesToCustomLineItemResponse.setter(Builder::failedAssociatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedAssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociateResourceResponseElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFULLY_ASSOCIATED_RESOURCES_FIELD, FAILED_ASSOCIATED_RESOURCES_FIELD));
    private final List<AssociateResourceResponseElement> successfullyAssociatedResources;
    private final List<AssociateResourceResponseElement> failedAssociatedResources;

    private BatchAssociateResourcesToCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyAssociatedResources = builder.successfullyAssociatedResources;
        this.failedAssociatedResources = builder.failedAssociatedResources;
    }

    public final boolean hasSuccessfullyAssociatedResources() {
        return this.successfullyAssociatedResources != null && !(this.successfullyAssociatedResources instanceof SdkAutoConstructList);
    }

    public final List<AssociateResourceResponseElement> successfullyAssociatedResources() {
        return this.successfullyAssociatedResources;
    }

    public final boolean hasFailedAssociatedResources() {
        return this.failedAssociatedResources != null && !(this.failedAssociatedResources instanceof SdkAutoConstructList);
    }

    public final List<AssociateResourceResponseElement> failedAssociatedResources() {
        return this.failedAssociatedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfullyAssociatedResources() ? this.successfullyAssociatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAssociatedResources() ? this.failedAssociatedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourcesToCustomLineItemResponse)) {
            return false;
        }
        BatchAssociateResourcesToCustomLineItemResponse other = (BatchAssociateResourcesToCustomLineItemResponse)((Object)obj);
        return this.hasSuccessfullyAssociatedResources() == other.hasSuccessfullyAssociatedResources() && Objects.equals(this.successfullyAssociatedResources(), other.successfullyAssociatedResources()) && this.hasFailedAssociatedResources() == other.hasFailedAssociatedResources() && Objects.equals(this.failedAssociatedResources(), other.failedAssociatedResources());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAssociateResourcesToCustomLineItemResponse").add("SuccessfullyAssociatedResources", this.hasSuccessfullyAssociatedResources() ? this.successfullyAssociatedResources() : null).add("FailedAssociatedResources", this.hasFailedAssociatedResources() ? this.failedAssociatedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfullyAssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.successfullyAssociatedResources()));
            }
            case "FailedAssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.failedAssociatedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateResourcesToCustomLineItemResponse, T> g) {
        return obj -> g.apply((BatchAssociateResourcesToCustomLineItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private List<AssociateResourceResponseElement> successfullyAssociatedResources = DefaultSdkAutoConstructList.getInstance();
        private List<AssociateResourceResponseElement> failedAssociatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateResourcesToCustomLineItemResponse model) {
            super(model);
            this.successfullyAssociatedResources(model.successfullyAssociatedResources);
            this.failedAssociatedResources(model.failedAssociatedResources);
        }

        public final List<AssociateResourceResponseElement.Builder> getSuccessfullyAssociatedResources() {
            List<AssociateResourceResponseElement.Builder> result = AssociateResourcesResponseListCopier.copyToBuilder(this.successfullyAssociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfullyAssociatedResources(Collection<AssociateResourceResponseElement.BuilderImpl> successfullyAssociatedResources) {
            this.successfullyAssociatedResources = AssociateResourcesResponseListCopier.copyFromBuilder(successfullyAssociatedResources);
        }

        @Override
        public final Builder successfullyAssociatedResources(Collection<AssociateResourceResponseElement> successfullyAssociatedResources) {
            this.successfullyAssociatedResources = AssociateResourcesResponseListCopier.copy(successfullyAssociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyAssociatedResources(AssociateResourceResponseElement ... successfullyAssociatedResources) {
            this.successfullyAssociatedResources(Arrays.asList(successfullyAssociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyAssociatedResources(Consumer<AssociateResourceResponseElement.Builder> ... successfullyAssociatedResources) {
            this.successfullyAssociatedResources(Stream.of(successfullyAssociatedResources).map(c -> (AssociateResourceResponseElement)((AssociateResourceResponseElement.Builder)AssociateResourceResponseElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssociateResourceResponseElement.Builder> getFailedAssociatedResources() {
            List<AssociateResourceResponseElement.Builder> result = AssociateResourcesResponseListCopier.copyToBuilder(this.failedAssociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAssociatedResources(Collection<AssociateResourceResponseElement.BuilderImpl> failedAssociatedResources) {
            this.failedAssociatedResources = AssociateResourcesResponseListCopier.copyFromBuilder(failedAssociatedResources);
        }

        @Override
        public final Builder failedAssociatedResources(Collection<AssociateResourceResponseElement> failedAssociatedResources) {
            this.failedAssociatedResources = AssociateResourcesResponseListCopier.copy(failedAssociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociatedResources(AssociateResourceResponseElement ... failedAssociatedResources) {
            this.failedAssociatedResources(Arrays.asList(failedAssociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociatedResources(Consumer<AssociateResourceResponseElement.Builder> ... failedAssociatedResources) {
            this.failedAssociatedResources(Stream.of(failedAssociatedResources).map(c -> (AssociateResourceResponseElement)((AssociateResourceResponseElement.Builder)AssociateResourceResponseElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateResourcesToCustomLineItemResponse build() {
            return new BatchAssociateResourcesToCustomLineItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemResponse> {
        public Builder successfullyAssociatedResources(Collection<AssociateResourceResponseElement> var1);

        public Builder successfullyAssociatedResources(AssociateResourceResponseElement ... var1);

        public Builder successfullyAssociatedResources(Consumer<AssociateResourceResponseElement.Builder> ... var1);

        public Builder failedAssociatedResources(Collection<AssociateResourceResponseElement> var1);

        public Builder failedAssociatedResources(AssociateResourceResponseElement ... var1);

        public Builder failedAssociatedResources(Consumer<AssociateResourceResponseElement.Builder> ... var1);
    }
}

