/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateTieringInput;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleScope;
import software.amazon.awssdk.services.billingconductor.model.PricingRuleType;
import software.amazon.awssdk.services.billingconductor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePricingRuleRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, CreatePricingRuleRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::clientToken)).setter(CreatePricingRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::name)).setter(CreatePricingRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::description)).setter(CreatePricingRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::scopeAsString)).setter(CreatePricingRuleRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::typeAsString)).setter(CreatePricingRuleRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ModifierPercentage").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::modifierPercentage)).setter(CreatePricingRuleRequest.setter(Builder::modifierPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::service)).setter(CreatePricingRuleRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::tags)).setter(CreatePricingRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BILLING_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingEntity").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::billingEntity)).setter(CreatePricingRuleRequest.setter(Builder::billingEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingEntity").build()}).build();
    private static final SdkField<CreateTieringInput> TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tiering").getter(CreatePricingRuleRequest.getter(CreatePricingRuleRequest::tiering)).setter(CreatePricingRuleRequest.setter(Builder::tiering)).constructor(CreateTieringInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD, TAGS_FIELD, BILLING_ENTITY_FIELD, TIERING_FIELD));
    private final String clientToken;
    private final String name;
    private final String description;
    private final String scope;
    private final String type;
    private final Double modifierPercentage;
    private final String service;
    private final Map<String, String> tags;
    private final String billingEntity;
    private final CreateTieringInput tiering;

    private CreatePricingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.tags = builder.tags;
        this.billingEntity = builder.billingEntity;
        this.tiering = builder.tiering;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final PricingRuleType type() {
        return PricingRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double modifierPercentage() {
        return this.modifierPercentage;
    }

    public final String service() {
        return this.service;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String billingEntity() {
        return this.billingEntity;
    }

    public final CreateTieringInput tiering() {
        return this.tiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billingEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.tiering());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePricingRuleRequest)) {
            return false;
        }
        CreatePricingRuleRequest other = (CreatePricingRuleRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.modifierPercentage(), other.modifierPercentage()) && Objects.equals(this.service(), other.service()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.billingEntity(), other.billingEntity()) && Objects.equals(this.tiering(), other.tiering());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePricingRuleRequest").add("ClientToken", (Object)this.clientToken()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", (Object)this.scopeAsString()).add("Type", (Object)this.typeAsString()).add("ModifierPercentage", (Object)this.modifierPercentage()).add("Service", (Object)this.service()).add("Tags", this.hasTags() ? this.tags() : null).add("BillingEntity", (Object)this.billingEntity()).add("Tiering", (Object)this.tiering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ModifierPercentage": {
                return Optional.ofNullable(clazz.cast(this.modifierPercentage()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "BillingEntity": {
                return Optional.ofNullable(clazz.cast(this.billingEntity()));
            }
            case "Tiering": {
                return Optional.ofNullable(clazz.cast(this.tiering()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePricingRuleRequest, T> g) {
        return obj -> g.apply((CreatePricingRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String name;
        private String description;
        private String scope;
        private String type;
        private Double modifierPercentage;
        private String service;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String billingEntity;
        private CreateTieringInput tiering;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePricingRuleRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.scope(model.scope);
            this.type(model.type);
            this.modifierPercentage(model.modifierPercentage);
            this.service(model.service);
            this.tags(model.tags);
            this.billingEntity(model.billingEntity);
            this.tiering(model.tiering);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return this.modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBillingEntity() {
            return this.billingEntity;
        }

        public final void setBillingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
        }

        @Override
        public final Builder billingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        public final CreateTieringInput.Builder getTiering() {
            return this.tiering != null ? this.tiering.toBuilder() : null;
        }

        public final void setTiering(CreateTieringInput.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(CreateTieringInput tiering) {
            this.tiering = tiering;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePricingRuleRequest build() {
            return new CreatePricingRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePricingRuleRequest> {
        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder scope(String var1);

        public Builder scope(PricingRuleScope var1);

        public Builder type(String var1);

        public Builder type(PricingRuleType var1);

        public Builder modifierPercentage(Double var1);

        public Builder service(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder billingEntity(String var1);

        public Builder tiering(CreateTieringInput var1);

        default public Builder tiering(Consumer<CreateTieringInput.Builder> tiering) {
            return this.tiering((CreateTieringInput)((CreateTieringInput.Builder)CreateTieringInput.builder().applyMutation(tiering)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

