/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateResourceResponseElement;
import software.amazon.awssdk.services.billingconductor.model.DisassociateResourcesResponseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateResourcesFromCustomLineItemResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, BatchDisassociateResourcesFromCustomLineItemResponse> {
    private static final SdkField<List<DisassociateResourceResponseElement>> SUCCESSFULLY_DISASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfullyDisassociatedResources").getter(BatchDisassociateResourcesFromCustomLineItemResponse.getter(BatchDisassociateResourcesFromCustomLineItemResponse::successfullyDisassociatedResources)).setter(BatchDisassociateResourcesFromCustomLineItemResponse.setter(Builder::successfullyDisassociatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfullyDisassociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisassociateResourceResponseElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DisassociateResourceResponseElement>> FAILED_DISASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedDisassociatedResources").getter(BatchDisassociateResourcesFromCustomLineItemResponse.getter(BatchDisassociateResourcesFromCustomLineItemResponse::failedDisassociatedResources)).setter(BatchDisassociateResourcesFromCustomLineItemResponse.setter(Builder::failedDisassociatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDisassociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisassociateResourceResponseElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFULLY_DISASSOCIATED_RESOURCES_FIELD, FAILED_DISASSOCIATED_RESOURCES_FIELD));
    private final List<DisassociateResourceResponseElement> successfullyDisassociatedResources;
    private final List<DisassociateResourceResponseElement> failedDisassociatedResources;

    private BatchDisassociateResourcesFromCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyDisassociatedResources = builder.successfullyDisassociatedResources;
        this.failedDisassociatedResources = builder.failedDisassociatedResources;
    }

    public final boolean hasSuccessfullyDisassociatedResources() {
        return this.successfullyDisassociatedResources != null && !(this.successfullyDisassociatedResources instanceof SdkAutoConstructList);
    }

    public final List<DisassociateResourceResponseElement> successfullyDisassociatedResources() {
        return this.successfullyDisassociatedResources;
    }

    public final boolean hasFailedDisassociatedResources() {
        return this.failedDisassociatedResources != null && !(this.failedDisassociatedResources instanceof SdkAutoConstructList);
    }

    public final List<DisassociateResourceResponseElement> failedDisassociatedResources() {
        return this.failedDisassociatedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfullyDisassociatedResources() ? this.successfullyDisassociatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedDisassociatedResources() ? this.failedDisassociatedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourcesFromCustomLineItemResponse)) {
            return false;
        }
        BatchDisassociateResourcesFromCustomLineItemResponse other = (BatchDisassociateResourcesFromCustomLineItemResponse)((Object)obj);
        return this.hasSuccessfullyDisassociatedResources() == other.hasSuccessfullyDisassociatedResources() && Objects.equals(this.successfullyDisassociatedResources(), other.successfullyDisassociatedResources()) && this.hasFailedDisassociatedResources() == other.hasFailedDisassociatedResources() && Objects.equals(this.failedDisassociatedResources(), other.failedDisassociatedResources());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateResourcesFromCustomLineItemResponse").add("SuccessfullyDisassociatedResources", this.hasSuccessfullyDisassociatedResources() ? this.successfullyDisassociatedResources() : null).add("FailedDisassociatedResources", this.hasFailedDisassociatedResources() ? this.failedDisassociatedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfullyDisassociatedResources": {
                return Optional.ofNullable(clazz.cast(this.successfullyDisassociatedResources()));
            }
            case "FailedDisassociatedResources": {
                return Optional.ofNullable(clazz.cast(this.failedDisassociatedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateResourcesFromCustomLineItemResponse, T> g) {
        return obj -> g.apply((BatchDisassociateResourcesFromCustomLineItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private List<DisassociateResourceResponseElement> successfullyDisassociatedResources = DefaultSdkAutoConstructList.getInstance();
        private List<DisassociateResourceResponseElement> failedDisassociatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateResourcesFromCustomLineItemResponse model) {
            super(model);
            this.successfullyDisassociatedResources(model.successfullyDisassociatedResources);
            this.failedDisassociatedResources(model.failedDisassociatedResources);
        }

        public final List<DisassociateResourceResponseElement.Builder> getSuccessfullyDisassociatedResources() {
            List<DisassociateResourceResponseElement.Builder> result = DisassociateResourcesResponseListCopier.copyToBuilder(this.successfullyDisassociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfullyDisassociatedResources(Collection<DisassociateResourceResponseElement.BuilderImpl> successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources = DisassociateResourcesResponseListCopier.copyFromBuilder(successfullyDisassociatedResources);
        }

        @Override
        public final Builder successfullyDisassociatedResources(Collection<DisassociateResourceResponseElement> successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources = DisassociateResourcesResponseListCopier.copy(successfullyDisassociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDisassociatedResources(DisassociateResourceResponseElement ... successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources(Arrays.asList(successfullyDisassociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDisassociatedResources(Consumer<DisassociateResourceResponseElement.Builder> ... successfullyDisassociatedResources) {
            this.successfullyDisassociatedResources(Stream.of(successfullyDisassociatedResources).map(c -> (DisassociateResourceResponseElement)((DisassociateResourceResponseElement.Builder)DisassociateResourceResponseElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DisassociateResourceResponseElement.Builder> getFailedDisassociatedResources() {
            List<DisassociateResourceResponseElement.Builder> result = DisassociateResourcesResponseListCopier.copyToBuilder(this.failedDisassociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedDisassociatedResources(Collection<DisassociateResourceResponseElement.BuilderImpl> failedDisassociatedResources) {
            this.failedDisassociatedResources = DisassociateResourcesResponseListCopier.copyFromBuilder(failedDisassociatedResources);
        }

        @Override
        public final Builder failedDisassociatedResources(Collection<DisassociateResourceResponseElement> failedDisassociatedResources) {
            this.failedDisassociatedResources = DisassociateResourcesResponseListCopier.copy(failedDisassociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDisassociatedResources(DisassociateResourceResponseElement ... failedDisassociatedResources) {
            this.failedDisassociatedResources(Arrays.asList(failedDisassociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDisassociatedResources(Consumer<DisassociateResourceResponseElement.Builder> ... failedDisassociatedResources) {
            this.failedDisassociatedResources(Stream.of(failedDisassociatedResources).map(c -> (DisassociateResourceResponseElement)((DisassociateResourceResponseElement.Builder)DisassociateResourceResponseElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateResourcesFromCustomLineItemResponse build() {
            return new BatchDisassociateResourcesFromCustomLineItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateResourcesFromCustomLineItemResponse> {
        public Builder successfullyDisassociatedResources(Collection<DisassociateResourceResponseElement> var1);

        public Builder successfullyDisassociatedResources(DisassociateResourceResponseElement ... var1);

        public Builder successfullyDisassociatedResources(Consumer<DisassociateResourceResponseElement.Builder> ... var1);

        public Builder failedDisassociatedResources(Collection<DisassociateResourceResponseElement> var1);

        public Builder failedDisassociatedResources(DisassociateResourceResponseElement ... var1);

        public Builder failedDisassociatedResources(Consumer<DisassociateResourceResponseElement.Builder> ... var1);
    }
}

