/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingPlanArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPricingPlansAssociatedWithPricingRuleResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListPricingPlansAssociatedWithPricingRuleResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingPeriod").getter(ListPricingPlansAssociatedWithPricingRuleResponse.getter(ListPricingPlansAssociatedWithPricingRuleResponse::billingPeriod)).setter(ListPricingPlansAssociatedWithPricingRuleResponse.setter(Builder::billingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()}).build();
    private static final SdkField<String> PRICING_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingRuleArn").getter(ListPricingPlansAssociatedWithPricingRuleResponse.getter(ListPricingPlansAssociatedWithPricingRuleResponse::pricingRuleArn)).setter(ListPricingPlansAssociatedWithPricingRuleResponse.setter(Builder::pricingRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRuleArn").build()}).build();
    private static final SdkField<List<String>> PRICING_PLAN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PricingPlanArns").getter(ListPricingPlansAssociatedWithPricingRuleResponse.getter(ListPricingPlansAssociatedWithPricingRuleResponse::pricingPlanArns)).setter(ListPricingPlansAssociatedWithPricingRuleResponse.setter(Builder::pricingPlanArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPricingPlansAssociatedWithPricingRuleResponse.getter(ListPricingPlansAssociatedWithPricingRuleResponse::nextToken)).setter(ListPricingPlansAssociatedWithPricingRuleResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD, PRICING_RULE_ARN_FIELD, PRICING_PLAN_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final String billingPeriod;
    private final String pricingRuleArn;
    private final List<String> pricingPlanArns;
    private final String nextToken;

    private ListPricingPlansAssociatedWithPricingRuleResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingRuleArn = builder.pricingRuleArn;
        this.pricingPlanArns = builder.pricingPlanArns;
        this.nextToken = builder.nextToken;
    }

    public final String billingPeriod() {
        return this.billingPeriod;
    }

    public final String pricingRuleArn() {
        return this.pricingRuleArn;
    }

    public final boolean hasPricingPlanArns() {
        return this.pricingPlanArns != null && !(this.pricingPlanArns instanceof SdkAutoConstructList);
    }

    public final List<String> pricingPlanArns() {
        return this.pricingPlanArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPricingPlanArns() ? this.pricingPlanArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingPlansAssociatedWithPricingRuleResponse)) {
            return false;
        }
        ListPricingPlansAssociatedWithPricingRuleResponse other = (ListPricingPlansAssociatedWithPricingRuleResponse)((Object)obj);
        return Objects.equals(this.billingPeriod(), other.billingPeriod()) && Objects.equals(this.pricingRuleArn(), other.pricingRuleArn()) && this.hasPricingPlanArns() == other.hasPricingPlanArns() && Objects.equals(this.pricingPlanArns(), other.pricingPlanArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPricingPlansAssociatedWithPricingRuleResponse").add("BillingPeriod", (Object)this.billingPeriod()).add("PricingRuleArn", (Object)this.pricingRuleArn()).add("PricingPlanArns", this.hasPricingPlanArns() ? this.pricingPlanArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.billingPeriod()));
            }
            case "PricingRuleArn": {
                return Optional.ofNullable(clazz.cast(this.pricingRuleArn()));
            }
            case "PricingPlanArns": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanArns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPricingPlansAssociatedWithPricingRuleResponse, T> g) {
        return obj -> g.apply((ListPricingPlansAssociatedWithPricingRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String billingPeriod;
        private String pricingRuleArn;
        private List<String> pricingPlanArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingPlansAssociatedWithPricingRuleResponse model) {
            super(model);
            this.billingPeriod(model.billingPeriod);
            this.pricingRuleArn(model.pricingRuleArn);
            this.pricingPlanArns(model.pricingPlanArns);
            this.nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return this.billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        @Transient
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getPricingRuleArn() {
            return this.pricingRuleArn;
        }

        public final void setPricingRuleArn(String pricingRuleArn) {
            this.pricingRuleArn = pricingRuleArn;
        }

        @Override
        @Transient
        public final Builder pricingRuleArn(String pricingRuleArn) {
            this.pricingRuleArn = pricingRuleArn;
            return this;
        }

        public final Collection<String> getPricingPlanArns() {
            if (this.pricingPlanArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pricingPlanArns;
        }

        public final void setPricingPlanArns(Collection<String> pricingPlanArns) {
            this.pricingPlanArns = PricingPlanArnsCopier.copy(pricingPlanArns);
        }

        @Override
        @Transient
        public final Builder pricingPlanArns(Collection<String> pricingPlanArns) {
            this.pricingPlanArns = PricingPlanArnsCopier.copy(pricingPlanArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pricingPlanArns(String ... pricingPlanArns) {
            this.pricingPlanArns(Arrays.asList(pricingPlanArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingPlansAssociatedWithPricingRuleResponse build() {
            return new ListPricingPlansAssociatedWithPricingRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPricingPlansAssociatedWithPricingRuleResponse> {
        public Builder billingPeriod(String var1);

        public Builder pricingRuleArn(String var1);

        public Builder pricingPlanArns(Collection<String> var1);

        public Builder pricingPlanArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

