/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billing.model.BillingViewStatus;
import software.amazon.awssdk.services.billing.model.BillingViewStatusReason;
import software.amazon.awssdk.services.billing.model.BillingViewStatusReasonsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingViewHealthStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingViewHealthStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(BillingViewHealthStatus.getter(BillingViewHealthStatus::statusCodeAsString)).setter(BillingViewHealthStatus.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusReasons").getter(BillingViewHealthStatus.getter(BillingViewHealthStatus::statusReasonsAsStrings)).setter(BillingViewHealthStatus.setter(Builder::statusReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, STATUS_REASONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillingViewHealthStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String statusCodeValue;
    private final List<String> statusReasons;

    private BillingViewHealthStatus(BuilderImpl builder) {
        this.statusCodeValue = builder.statusCodeValue;
        this.statusReasons = builder.statusReasons;
    }

    public final BillingViewStatus statusCode() {
        return BillingViewStatus.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final List<BillingViewStatusReason> statusReasons() {
        return BillingViewStatusReasonsCopier.copyStringToEnum(this.statusReasons);
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasonsAsStrings() {
        return this.statusReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasonsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingViewHealthStatus)) {
            return false;
        }
        BillingViewHealthStatus other = (BillingViewHealthStatus)obj;
        return Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasonsAsStrings(), other.statusReasonsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BillingViewHealthStatus").add("StatusCode", (Object)this.statusCodeAsString()).add("StatusReasons", this.hasStatusReasons() ? this.statusReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasonsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingViewHealthStatus, T> g) {
        return obj -> g.apply((BillingViewHealthStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String statusCodeValue;
        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillingViewHealthStatus model) {
            this.statusCode(model.statusCodeValue);
            this.statusReasonsWithStrings(model.statusReasons);
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(BillingViewStatus statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = BillingViewStatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasonsWithStrings(Collection<String> statusReasons) {
            this.statusReasons = BillingViewStatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasonsWithStrings(String ... statusReasons) {
            this.statusReasonsWithStrings(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        public final Builder statusReasons(Collection<BillingViewStatusReason> statusReasons) {
            this.statusReasons = BillingViewStatusReasonsCopier.copyEnumToString(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(BillingViewStatusReason ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public BillingViewHealthStatus build() {
            return new BillingViewHealthStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingViewHealthStatus> {
        public Builder statusCode(String var1);

        public Builder statusCode(BillingViewStatus var1);

        public Builder statusReasonsWithStrings(Collection<String> var1);

        public Builder statusReasonsWithStrings(String ... var1);

        public Builder statusReasons(Collection<BillingViewStatusReason> var1);

        public Builder statusReasons(BillingViewStatusReason ... var1);
    }
}

